<?php
/*
 *  @Module Name: AP Page Builder
 *  @Website: apollotheme.com - prestashop template provider
 *  @author Apollotheme <apollotheme@gmail.com>
 *  @copyright  2007-2016 Apollotheme
 *  @description: ApPageBuilder is module help you can build content for your shop
 */
if (!class_exists("ApPageSetup")) {

    class ApPageSetup
    {

        public static function getTabs()
        {
            return array(
                array(
                    'class_name' => 'AdminApPageBuilderProfiles',
                    'name' => 'Ap Profiles Manage',
                ),
                array(
                    'class_name' => 'AdminApPageBuilderPositions',
                    'name' => 'Ap Positions Manage',
                ),
                array(
                    'class_name' => 'AdminApPageBuilderHome',
                    'name' => 'Ap Hook Builder',
                    'id_parent' => -1,
                ),
                array(
                    'class_name' => 'AdminApPageBuilderProducts',
                    'name' => 'Ap Products List Builder',
                ),
                array(
                    'class_name' => 'AdminApPageBuilderHook',
                    'name' => 'Ap Hook Control Panel',
                ),
                array(
                    'class_name' => 'AdminApPageBuilderThemeEditor',
                    'name' => 'Ap Live Theme Editor',
                ),
                array(
                    'class_name' => 'AdminApPageBuilderModule',
                    'name' => 'Ap Module Configuration',
                ),
                array(
                    'class_name' => 'AdminApPageBuilderThemeConfiguration',
                    'name' => 'Ap Theme Configuration',
                ),
                array(
                    'class_name' => 'AdminApPageBuilderImages',
                    'name' => 'Ap Image Manage',
                    'id_parent' => -1,
                ),
                array(
                    'class_name' => 'AdminApPageBuilderShortcodes',
                    'name' => 'Ap Shortcodes Builder',
                    'id_parent' => -1,
                ),
            );
        }

        public static function createTables($reset = 0)
        {
            if ($reset == 0 && file_exists(_PS_MODULE_DIR_.'appagebuilder')) {
                require_once(_PS_MODULE_DIR_.'appagebuilder/libs/LeoDataSample.php');

                $sample = new Datasample();
                if ($sample->processImport('appagebuilder')) {
                    return true;
                }
            }
            $drop = '';
            if ($reset == 1)
                $drop = 'DROP TABLE IF EXISTS `'._DB_PREFIX_.'appagebuilder_profiles`;';
            //each shop will have one or more profile
            $res = (bool)Db::getInstance()->execute($drop.'
                CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'appagebuilder_profiles` (
                    `id_appagebuilder_profiles` int(11) NOT NULL AUTO_INCREMENT,
                        `name` varchar(255),
                        `group_box` varchar(255),
                        `profile_key` varchar(255),
                        `page` varchar(255),
                        `params` text,
                        `header` int(11) unsigned NOT NULL,
                        `content` int(11) unsigned NOT NULL,
                        `footer` int(11) unsigned NOT NULL,
                        `product` int(11) unsigned NOT NULL,
                        `active` TINYINT(1),
                    PRIMARY KEY (`id_appagebuilder_profiles`)
                ) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=UTF8;
            ');
            if ($reset == 1)
                $drop = 'DROP TABLE IF EXISTS `'._DB_PREFIX_.'appagebuilder_profiles_lang`;';
            $res &= Db::getInstance()->execute($drop.'
                CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'appagebuilder_profiles_lang` (
                   `id_appagebuilder_profiles` int(11) NOT NULL AUTO_INCREMENT,
                   `id_lang` int(10) unsigned NOT NULL,
                   `friendly_url` varchar(255),
                    `meta_title` varchar(255),
                    `meta_description` varchar(255),
                    `meta_keywords` varchar(255),
                   PRIMARY KEY (`id_appagebuilder_profiles`, `id_lang`)
                ) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=UTF8;
            ');
            if ($reset == 1)
                $drop = 'DROP TABLE IF EXISTS `'._DB_PREFIX_.'appagebuilder_profiles_shop`;';
            $res &= Db::getInstance()->execute($drop.'
                CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'appagebuilder_profiles_shop` (
                  `id_appagebuilder_profiles` int(11) NOT NULL AUTO_INCREMENT,
                  `id_shop` int(10) unsigned NOT NULL,
                  `active` TINYINT(1),
                  PRIMARY KEY (`id_appagebuilder_profiles`, `id_shop`)
                ) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=UTF8;
            ');
            if ($reset == 1)
                $drop = 'DROP TABLE IF EXISTS `'._DB_PREFIX_.'appagebuilder_products`;';
            //we can create product item for each shop
            $res &= (bool)Db::getInstance()->execute($drop.'
                CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'appagebuilder_products` (
                    `id_appagebuilder_products` int(11) NOT NULL AUTO_INCREMENT,
                        `plist_key` varchar(255),
                        `name` varchar(255),
                        `class` varchar(255),
                        `params` text,
                        `type` TINYINT(1),
                        `active` TINYINT(1),
                    PRIMARY KEY (`id_appagebuilder_products`)
                ) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=UTF8;
            ');
            if ($reset == 1)
                $drop = 'DROP TABLE IF EXISTS `'._DB_PREFIX_.'appagebuilder_products_shop`;';
            $res &= Db::getInstance()->execute($drop.'
                CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'appagebuilder_products_shop` (
                  `id_appagebuilder_products` int(11) NOT NULL AUTO_INCREMENT,
                  `id_shop` int(10) unsigned NOT NULL,
                  `active` TINYINT(1),
                  PRIMARY KEY (`id_appagebuilder_products`, `id_shop`)
                ) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=UTF8;
            ');
            if ($reset == 1)
                $drop = 'DROP TABLE IF EXISTS `'._DB_PREFIX_.'appagebuilder`;';
            $res &= (bool)Db::getInstance()->execute($drop.'
                CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'appagebuilder` (
                    `id_appagebuilder` int(11) NOT NULL AUTO_INCREMENT,
                        `id_appagebuilder_positions` int(11) NOT NULL,
                        `hook_name` varchar(255),
                    PRIMARY KEY (`id_appagebuilder`)
                ) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=UTF8;
            ');

            if ($reset == 1)
                $drop = 'DROP TABLE IF EXISTS `'._DB_PREFIX_.'appagebuilder_shop`;';
            $res &= Db::getInstance()->execute($drop.'
                CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'appagebuilder_shop` (
                  `id_appagebuilder` int(11) NOT NULL AUTO_INCREMENT,
                  `id_shop` int(10) unsigned NOT NULL,
                  PRIMARY KEY (`id_appagebuilder`, `id_shop`)
                ) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=UTF8;
            ');
            if ($reset == 1)
                $drop = 'DROP TABLE IF EXISTS `'._DB_PREFIX_.'appagebuilder_lang`;';
            $res &= Db::getInstance()->execute($drop.'
                CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'appagebuilder_lang` (
                   `id_appagebuilder` int(11) NOT NULL AUTO_INCREMENT,
                   `id_lang` int(10) unsigned NOT NULL,
                   `params` text,
                   PRIMARY KEY (`id_appagebuilder`, `id_lang`)
                ) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=UTF8;
                
            ');
            if ($reset == 1)
                $drop = 'DROP TABLE IF EXISTS `'._DB_PREFIX_.'appagebuilder_positions`;';
            $res &= Db::getInstance()->execute($drop.'
                CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'appagebuilder_positions` (
                    `id_appagebuilder_positions` int(11) NOT NULL AUTO_INCREMENT,
                    `name` varchar(255) NOT NULL,
                    `position` varchar(255) NOT NULL,
                    `position_key` varchar(255) NOT NULL,
                    `params` text,
                    PRIMARY KEY (`id_appagebuilder_positions`)
                ) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=UTF8;
            ');
            if ($reset == 1)
                $drop = 'DROP TABLE IF EXISTS `'._DB_PREFIX_.'appagebuilder_positions_shop`;';
            $res &= Db::getInstance()->execute($drop.'
                CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'appagebuilder_positions_shop` (
                  `id_appagebuilder_positions` int(11) NOT NULL AUTO_INCREMENT,
                  `id_shop` int(10) unsigned NOT NULL,
                  PRIMARY KEY (`id_appagebuilder_positions`, `id_shop`)
                ) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=UTF8;
            ');
            return $res;
        }

        public static function installSample()
        {
            $id_shop = Context::getContext()->shop->id;

            //table appagebuilder_profiles
            Db::getInstance()->execute('TRUNCATE TABLE `'._DB_PREFIX_.'appagebuilder_profiles`');
            $sql = 'INSERT INTO `'._DB_PREFIX_.'appagebuilder_profiles` (`id_appagebuilder_profiles`, `name`, `profile_key`, `page`, `params`, `header`, `content`, `footer`, `product`, `active`) VALUES
(1, \'Home page\', \'profile1426561433\', \'index\', \'{"displayTopColumn":{"exception":[""]},"displayHome":{"exception":[""]},"fullwidth_index_hook":{"displayBanner":0,"displayNav":0,"displayTop":"1","displayTopColumn":"1","displayHome":0,"displayFooter":0},"fullwidth_other_hook":{"displayBanner":0,"displayNav":0,"displayTop":0,"displayTopColumn":0,"displayFooter":0}}\', 1, 2, 27, 4, NULL),
(2, \'Detail demo\', \'profile1426579529\', \'index\', \'{"displayTopColumn":{"exception":[""]},"displayHome":{"exception":[""]},"fullwidth_index_hook":{"displayBanner":0,"displayNav":0,"displayTop":"1","displayTopColumn":"1","displayHome":0,"displayFooter":0},"fullwidth_other_hook":{"displayBanner":0,"displayNav":0,"displayTop":0,"displayTopColumn":0,"displayFooter":0}}\', 5, 6, 28, 8, NULL),
(3, \'Home page 1\', \'profile1427119013\', \'index\', \'{"displayHome":{"exception":[""]}}\', 9, 10, 25, 12, NULL),
(4, \'Home page 2\', \'profile1427116699\', \'index\', \'{"displayTopColumn":{"exception":[""]},"displayHome":{"exception":[""]}}\', 13, 14, 26, 16, NULL),
(5, \'Home page 3\', \'profile1427805353\', \'index\', \'{"displayTopColumn":{"exception":[""]},"displayHome":{"exception":[""]},"fullwidth_index_hook":{"displayBanner":0,"displayNav":0,"displayTop":"1","displayTopColumn":"1","displayHome":0,"displayFooter":0},"fullwidth_other_hook":{"displayBanner":0,"displayNav":0,"displayTop":0,"displayTopColumn":0,"displayHome":0,"displayFooter":0}}\', 21, 22, 29, 24, NULL);';
            Db::getInstance()->execute($sql);

            //table appagebuilder_profiles_shop
            Db::getInstance()->execute('TRUNCATE TABLE `'._DB_PREFIX_.'appagebuilder_profiles_shop`');
            $sql = 'INSERT INTO `'._DB_PREFIX_.'appagebuilder_profiles_shop` (`id_appagebuilder_profiles`, `id_shop`, `active`) VALUES
(1, ID_SHOP, 0),
(2, ID_SHOP, 0),
(3, ID_SHOP, 1),
(4, ID_SHOP, 0),
(5, ID_SHOP, 0);';
            $sql = str_replace('ID_SHOP', $id_shop, $sql);
            Db::getInstance()->execute($sql);

            //table appagebuilder_positions
            Db::getInstance()->execute('TRUNCATE TABLE `'._DB_PREFIX_.'appagebuilder_positions`');
            $sql = "INSERT INTO `"._DB_PREFIX_."appagebuilder_positions` (`id_appagebuilder_positions`, `name`, `position`, `position_key`, `params`) VALUES
(1, 'header1426579629', 'header', 'position1426579629', NULL),
(2, 'content1426564879', 'content', 'position1426564879', NULL),
(3, 'footer1426566238', 'footer', 'position1426566238', NULL),
(4, 'product1426580519', 'product', 'position1426580519', NULL),
(5, 'header1426564187', 'header', 'position1426564187', NULL),
(6, 'content1426564490', 'content', 'position1426564490', NULL),
(7, 'footer1426578355', 'footer', 'position1426578355', NULL),
(8, 'product1426581801', 'product', 'position1426581801', NULL),
(9, 'header1427111294', 'header', 'position1427111294', NULL),
(10, 'content1427129695', 'content', 'position1427129695', NULL),
(11, 'footer1427107373', 'footer', 'position1427107373', NULL),
(12, 'product1427129206', 'product', 'position1427129206', NULL),
(13, 'header1427138535', 'header', 'position1427138535', NULL),
(14, 'content1427116604', 'content', 'position1427116604', NULL),
(15, 'footer1427111534', 'footer', 'position1427111534', NULL),
(16, 'product1427111243', 'product', 'position1427111243', NULL),
(17, 'header1427806687', 'header', 'position1427806687', NULL),
(18, 'content1427819338', 'content', 'position1427819338', NULL),
(19, 'footer1427821311', 'footer', 'position1427821311', NULL),
(20, 'product1427816721', 'product', 'position1427816721', NULL),
(21, 'header1434016210', 'header', 'position1434016210', NULL),
(22, 'content1434021220', 'content', 'position1434021220', NULL),
(23, 'footer1434021922', 'footer', 'position1434021922', NULL),
(24, 'product1434038427', 'product', 'position1434038427', NULL),
(25, 'footer1435143282', 'footer', 'position1435143282', NULL),
(26, 'footer1435158937', 'footer', 'position1435158937', NULL),
(27, 'footer1435144169', 'footer', 'position1435144169', NULL),
(28, 'footer1435153254', 'footer', 'position1435153254', NULL),
(29, 'footer1435237119', 'footer', 'position1435237119', NULL);";
            Db::getInstance()->execute($sql);

            //table appagebuilder_positions_shop
            Db::getInstance()->execute('TRUNCATE TABLE `'._DB_PREFIX_.'appagebuilder_positions_shop`');
            $sql = "INSERT INTO `"._DB_PREFIX_."appagebuilder_positions_shop` (`id_appagebuilder_positions`, `id_shop`) VALUES
(1, ID_SHOP),
(2, ID_SHOP),
(4, ID_SHOP),
(5, ID_SHOP),
(6, ID_SHOP),
(8, ID_SHOP),
(9, ID_SHOP),
(10, ID_SHOP),
(12, ID_SHOP),
(13, ID_SHOP),
(14, ID_SHOP),
(16, ID_SHOP),
(21, ID_SHOP),
(22, ID_SHOP),
(24, ID_SHOP),
(25, ID_SHOP),
(26, ID_SHOP),
(27, ID_SHOP),
(28, ID_SHOP),
(29, ID_SHOP),
(30, ID_SHOP);";
            $sql = str_replace('ID_SHOP', $id_shop, $sql);
            Db::getInstance()->execute($sql);

            //table appagebuilder
            Db::getInstance()->execute('TRUNCATE TABLE `'._DB_PREFIX_.'appagebuilder`');
            $sql = "INSERT INTO `"._DB_PREFIX_."appagebuilder` (`id_appagebuilder`, `id_appagebuilder_positions`, `hook_name`) VALUES
(1, 1, 'displayBanner'),
(2, 1, 'displayNav'),
(3, 1, 'displayTop'),
(4, 2, 'displayTopColumn'),
(5, 2, 'displayLeftColumn'),
(6, 2, 'displayHome'),
(7, 2, 'displayRightColumn'),
(8, 3, 'displayFooter'),
(9, 4, 'displayFooterProduct'),
(10, 4, 'displayRightColumnProduct'),
(11, 5, 'displayBanner'),
(12, 5, 'displayNav'),
(13, 5, 'displayTop'),
(14, 6, 'displayTopColumn'),
(15, 6, 'displayLeftColumn'),
(16, 6, 'displayHome'),
(17, 6, 'displayRightColumn'),
(18, 7, 'displayFooter'),
(19, 8, 'displayFooterProduct'),
(20, 8, 'displayRightColumnProduct'),
(21, 9, 'displayBanner'),
(22, 9, 'displayNav'),
(23, 9, 'displayTop'),
(24, 10, 'displayTopColumn'),
(25, 10, 'displayLeftColumn'),
(26, 10, 'displayHome'),
(27, 10, 'displayRightColumn'),
(28, 11, 'displayFooter'),
(29, 12, 'displayFooterProduct'),
(30, 12, 'displayRightColumnProduct'),
(31, 13, 'displayBanner'),
(32, 13, 'displayNav'),
(33, 13, 'displayTop'),
(34, 14, 'displayTopColumn'),
(35, 14, 'displayLeftColumn'),
(36, 14, 'displayHome'),
(37, 14, 'displayRightColumn'),
(38, 15, 'displayFooter'),
(39, 16, 'displayFooterProduct'),
(40, 16, 'displayRightColumnProduct'),
(41, 17, 'displayBanner'),
(42, 17, 'displayNav'),
(43, 17, 'displayTop'),
(44, 18, 'displayTopColumn'),
(45, 18, 'displayLeftColumn'),
(46, 18, 'displayHome'),
(47, 18, 'displayRightColumn'),
(48, 19, 'displayFooter'),
(49, 20, 'displayFooterProduct'),
(50, 20, 'displayRightColumnProduct'),
(51, 21, 'displayBanner'),
(52, 21, 'displayNav'),
(53, 21, 'displayTop'),
(54, 22, 'displayTopColumn'),
(55, 22, 'displayLeftColumn'),
(56, 22, 'displayHome'),
(57, 22, 'displayRightColumn'),
(58, 23, 'displayFooter'),
(59, 24, 'displayFooterProduct'),
(60, 24, 'displayRightColumnProduct'),
(61, 25, 'displayFooter'),
(62, 26, 'displayFooter'),
(63, 27, 'displayFooter'),
(64, 28, 'displayFooter'),
(65, 29, 'displayFooter');";
            Db::getInstance()->execute($sql);

            //table appagebuilder_lang
            Db::getInstance()->execute('TRUNCATE TABLE `'._DB_PREFIX_.'appagebuilder_lang`');
            $sqlArray[] = 'INSERT INTO `'._DB_PREFIX_.'appagebuilder_lang` (`id_appagebuilder`, `id_lang`, `params`) VALUES
(4, ID_LANG, \'[ApRow form_id="form_3686922720630846" container="container" class="row hidden-sp hidden-xs hidden-sm" bg_config="fullwidth" bg_type="normal" bg_img="background_image.jpg" bg_position="top" bg_repeat="no-repeat" parallax_speed="0.1" parallax_axis="both" parallax_strength="0.5" parallax_rid="0.5" parallax_hoffsets="0.1" parallax_voffsets="0.1" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id=""][ApColumn form_id="form_1961775034670416" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_7402022593420345" animation="none" animation_delay="0.5" is_open="0" image="icon_3.png" description="<div class=_APQUOT_topcolumn_APQUOT_>_APENTER_<div class=_APQUOT_title_top_column_APQUOT_><a href=_APQUOT_#_APQUOT_>code</a></div>_APENTER_Follow Prestashop Standards with clean code, user can easily use and change. Our code is easy to read, whether that reader is the original author of the code or somebody else. Our code is easy to extend and refactor, and it’s easy to fix bugs in the code base.</div>"][/ApImage][/ApColumn][ApColumn form_id="form_8593734067155859" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_2658206856118479" animation="none" animation_delay="0.5" is_open="0" image="icon2.png" description="<div class=_APQUOT_topcolumn_APQUOT_>_APENTER_<div class=_APQUOT_title_top_column_APQUOT_><a href=_APQUOT_#_APQUOT_>Community</a></div>_APENTER_We are always looking for partners to develop Prestashop Community stronger. Let’s try our module to experience powerful module of prestashop. Apollo Page Builder contains all you need for your site.</div>"][/ApImage][/ApColumn][ApColumn form_id="form_3705600709413917" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_7655917549242618" animation="none" animation_delay="0.5" is_open="0" width="auto" height="auto" image="icon1.png" description="<div class=_APQUOT_topcolumn_APQUOT_>_APENTER_<div class=_APQUOT_title_top_column_APQUOT_><a href=_APQUOT_#_APQUOT_>Support</a></div>_APENTER_We committed that we always beside you to help you build your site in the best way, we reply all emails within 24 hours. We always focus on Supporting Activities with custom work or tickets .Serving customer is our happiness. Thank you for your trust and use our New Module AP Page Builder.</div>"][/ApImage][/ApColumn][/ApRow]\'),
(6, ID_LANG, \'[ApRow form_id="form_8958369858835936" class="row text_description" bg_config="boxed" bg_type="normal" bg_repeat="no-repeat" parallax_speed="0.1" parallax_axis="both" parallax_strength="0.5" parallax_rid="0.5" parallax_hoffsets="0.1" parallax_voffsets="0.1" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id=""][ApColumn form_id="form_7901601885578270" lg="12" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApHtml form_id="form_5162253971326877" content_html="<div>Apollo Page Builder is the powerful module followed Prestashop Standards which contained necessary features to build professional Prestashop site in minutes. <br />The powerful <strong> 20 WIDGETS of AP Page Builder</strong> (ONLY FOR APOLLO PAGE BUILDER)</div>"][/ApHtml][/ApColumn][/ApRow][ApRow form_id="form_41198213881828815" id="group_page" class="row" bg_position="top" bg_repeat="no-repeat" bg_type="static" parallax_speed="0.1" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id=""][ApColumn form_id="form_5775116351907568" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_7904919450235082" animation="none" animation_delay="0.5" url="http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#accodition" is_open="1" width="100%" height="auto" title="Accodition" image="3.jpg"][/ApImage][ApRawHtml form_id="form_2194125725960049" content_html="<a href=_APQUOT_http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#accodition_APQUOT_>Accordion</a>"][/ApRawHtml][/ApColumn][ApColumn form_id="form_5357719750758712" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_7269941533062871" animation="none" animation_delay="0.5" url="http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#alert" is_open="1" width="100%" height="auto" title="Alert" image="2.jpg"][/ApImage][ApRawHtml form_id="form_6234940794876558" content_html="<a href=_APQUOT_http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#alert_APQUOT_>Alert</a>"][/ApRawHtml][/ApColumn][ApColumn form_id="form_38212983986944475" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_26163907450828416" animation="none" animation_delay="0.5" url="http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#block_category" is_open="1" width="100%" height="auto" title="block carousel" image="product_list.jpg"][/ApImage][ApRawHtml form_id="form_9596803194517628" content_html="<a href=_APQUOT_http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#block_category_APQUOT_>Block carousel</a>"][/ApRawHtml][/ApColumn][ApColumn form_id="form_9211861342411052" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_18945009606898228" animation="none" animation_delay="0.5" url="http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#links" is_open="1" width="100%" height="auto" title="block links" image="block_links.jpg"][/ApImage][ApRawHtml form_id="form_7673725587499175" content_html="<a href=_APQUOT_http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#links_APQUOT_>block links</a>"][/ApRawHtml][/ApColumn][ApColumn form_id="form_9092739355051208" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_7596325259291667" animation="none" animation_delay="0.5" url="http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#button" is_open="1" width="100%" height="auto" title="button " image="button.jpg"][/ApImage][ApRawHtml form_id="form_4526442062782225" content_html="<a href=_APQUOT_http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#button_APQUOT_>button</a>"][/ApRawHtml][/ApColumn][ApColumn form_id="form_15711979104686025" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_6709537065975945" animation="none" animation_delay="0.5" url="http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#img_of_category" is_open="1" width="100%" height="auto" title="image_categories" image="image_category.jpg"][/ApImage][ApRawHtml form_id="form_2642164553283550" content_html="<a href=_APQUOT_http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#img_of_category_APQUOT_>images of category</a>"][/ApRawHtml][/ApColumn][ApColumn form_id="form_7161953881140876" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_8537902373009066" animation="none" animation_delay="0.5" url="http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#facebook" is_open="1" width="100%" height="auto" title="facebooks" image="faceboook.jpg"][/ApImage][ApRawHtml form_id="form_8193779589404013" content_html="<a href=_APQUOT_http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#facebook_APQUOT_>Facebook</a>"][/ApRawHtml][/ApColumn][ApColumn form_id="form_7098649962565448" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_3926912895065418" animation="none" animation_delay="0.5" url="http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#font" is_open="1" width="100%" height="auto" title="font awesome" image="font.jpg"][/ApImage][ApRawHtml form_id="form_7218138914833556" content_html="<a href=_APQUOT_http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#font_APQUOT_>font awesome</a>"][/ApRawHtml][/ApColumn][ApColumn form_id="form_27815346833934566" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_6821152581189937" animation="none" animation_delay="0.5" url="http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#fullslide" is_open="1" width="100%" height="auto" title="full slider" image="full-slieder.jpg"][/ApImage][ApRawHtml form_id="form_1869594675319303" content_html="<a href=_APQUOT_http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#fullslide_APQUOT_>full slider</a>"][/ApRawHtml][/ApColumn][ApColumn form_id="form_4782608802842203" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_25629664159621265" animation="none" animation_delay="0.5" url="http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#googlemap" is_open="1" width="100%" height="auto" title="map" image="map.jpg"][/ApImage][ApRawHtml form_id="form_6830763602009787" content_html="<a href=_APQUOT_http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#googlemap_APQUOT_>google map</a>"][/ApRawHtml][/ApColumn][ApColumn form_id="form_8293157177460327" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_8092817235136262" animation="none" animation_delay="0.5" url="http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#html" is_open="1" width="100%" height="auto" title="html" image="html.jpg"][/ApImage][ApRawHtml form_id="form_5930013404564919" content_html="<a href=_APQUOT_http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#html_APQUOT_>html</a>"][/ApRawHtml][/ApColumn][ApColumn form_id="form_8407181663855103" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_8067974622241449" animation="none" animation_delay="0.5" url="http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#images" is_open="1" width="100%" height="auto" title="images" image="img-4.jpg"][/ApImage][ApRawHtml form_id="form_7213304642943474" content_html="<a href=_APQUOT_http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#images_APQUOT_>images</a>"][/ApRawHtml][/ApColumn][ApColumn form_id="form_4409647243516094" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_7214858629172831" animation="none" animation_delay="0.5" url="http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#imagesgallery" is_open="1" width="100%" height="auto" title="images_gallery" image="image_category_1.jpg"][/ApImage][ApRawHtml form_id="form_7993874311832527" content_html="<a href=_APQUOT_http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#imagesgallery_APQUOT_>images gallery</a>"][/ApRawHtml][/ApColumn][ApColumn form_id="form_41350964288708805" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_17640208447584045" animation="none" animation_delay="0.5" url="http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#imagesgalleryproduct" is_open="1" width="100%" height="auto" title="Imgaes gallery product" image="image_category.jpg"][/ApImage][ApRawHtml form_id="form_9612141034514104" content_html="<a href=_APQUOT_http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#imagesgalleryproduct_APQUOT_>images gallery product</a>"][/ApRawHtml][/ApColumn][ApColumn form_id="form_9701673867678509" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_6245434392312563" animation="none" animation_delay="0.5" alt="" css_class="" url="http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#lastblog" is_open="1" width="100%" height="auto" override_folder="" title="lastblog" image="blog.jpg" description=""][/ApImage][ApRawHtml form_id="form_6063249375299222" override_folder="" title="" content_html="<a href=_APQUOT_http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#lastblog_APQUOT_>lastest  blog</a>"][/ApRawHtml][/ApColumn][ApColumn form_id="form_2915136671725974" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_8249443741006968" animation="none" animation_delay="0.5" url="http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#manu" is_open="1" width="100%" height="auto" title="manufaceture" image="manufaceture.jpg"][/ApImage][ApRawHtml form_id="form_6304748525823822" content_html="<a href=_APQUOT_http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#manu_APQUOT_>manufaceturers carousel</a>"][/ApRawHtml][/ApColumn][ApColumn form_id="form_8329397956477681" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_8834243708387662" animation="none" animation_delay="0.5" url="http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#carousel" is_open="1" width="100%" height="auto" title="carousel" image="product_list.jpg"][/ApImage][ApRawHtml form_id="form_6529808958319341" content_html="<a href=_APQUOT_http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#carousel_APQUOT_>product carousel</a>"][/ApRawHtml][/ApColumn][ApColumn form_id="form_32266330273001405" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_3739328072814081" animation="none" animation_delay="0.5" url="http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#list" is_open="1" width="100%" height="auto" title="product list" image="product_list.jpg"][/ApImage][ApRawHtml form_id="form_5571571412115208" content_html="<a href=_APQUOT_http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#list_APQUOT_>product list</a>"][/ApRawHtml][/ApColumn][ApColumn form_id="form_37016687958238785" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_6489358019109414" animation="none" animation_delay="0.5" alt="" css_class="" url="http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#rawhtml" is_open="1" width="100%" height="auto" override_folder="" title="facebooks" image="raw.jpg" description=""][/ApImage][ApRawHtml form_id="form_6825064247045820" override_folder="" title="" content_html="<a href=_APQUOT_http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#rawhtml_APQUOT_>raw html</a>"][/ApRawHtml][/ApColumn][ApColumn form_id="form_8559706108341141" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_7907281733091197" animation="none" animation_delay="0.5" alt="" css_class="" url="http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#slideshow" is_open="1" width="100%" height="auto" override_folder="" title="slider" image="slider.jpg" description=""][/ApImage][ApRawHtml form_id="form_6151081969461139" override_folder="" title="" content_html="<a href=_APQUOT_http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#slideshow_APQUOT_>slide show</a>"][/ApRawHtml][/ApColumn][ApColumn form_id="form_4950853231992660" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_43922688319542345" animation="none" animation_delay="0.5" url="http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#tab" is_open="1" width="100%" height="auto" title="tabs" image="tabs.jpg"][/ApImage][ApRawHtml form_id="form_12870826219600295" content_html="<a href=_APQUOT_http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#tab_APQUOT_>tabs</a>"][/ApRawHtml][/ApColumn][ApColumn form_id="form_5119993332264302" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_8865655534576876" animation="none" animation_delay="0.5" url="http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#twitter" is_open="1" width="100%" height="auto" title="twitter" image="twitter.jpg"][/ApImage][ApRawHtml form_id="form_5866377597839060" content_html="<a href=_APQUOT_http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#twitter_APQUOT_>twitter</a>"][/ApRawHtml][/ApColumn][ApColumn form_id="form_4936287721588379" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_4655208936600110" animation="none" animation_delay="0.5" url="http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#video" is_open="1" width="100%" height="auto" title="Video" image="video.jpg"][/ApImage][ApRawHtml form_id="form_6415173632284820" content_html="<a href=_APQUOT_http://demothemes.info/prestashop/appagebuilder/?id_appagebuilder_profiles=2#video_APQUOT_> Video</a>"][/ApRawHtml][/ApColumn][/ApRow][ApRow form_id="form_18593387723897532" id="home_page" class="row" bg_color="#000000" bg_position="top" bg_repeat="no-repeat" bg_type="static" parallax_speed="0.1" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id=""][ApColumn form_id="form_23709347025840305" lg="12" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApHtml form_id="form_8621712636330598" content_html="<div>Apollo Page Builder module created three default home pages for user can quickly run your store. In addition, AP Page Builder also permitted you to create own styles home pages.</div>"][/ApHtml][/ApColumn][ApColumn form_id="form_6150762857626143" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApRawHtml form_id="form_7006985281765558" content_html="<div class=_APQUOT_title_home_page_APQUOT_>home page 1</div>"][/ApRawHtml][ApImage form_id="form_4077927026684104" animation="none" animation_delay="0.5" url="?id_appagebuilder_profiles=3" is_open="1" width="100%" height="auto" title="Home page 1" image="home_page_3.jpg"][/ApImage][/ApColumn][ApColumn form_id="form_11597642044729098" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApRawHtml form_id="form_5533801505542806" content_html="<div class=_APQUOT_title_home_page_APQUOT_>home page 2</div>"][/ApRawHtml][ApImage form_id="form_9092293309836280" animation="none" animation_delay="0.5" url="?id_appagebuilder_profiles=4" is_open="1" width="100%" height="auto" title="Home page 1" image="home_page_2.jpg"][/ApImage][/ApColumn][ApColumn form_id="form_6911840373485474" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApRawHtml form_id="form_29501135947423115" content_html="<div class=_APQUOT_title_home_page_APQUOT_>home page 3</div>"][/ApRawHtml][ApImage form_id="form_4163228080425177" animation="none" animation_delay="0.5" url="?id_appagebuilder_profiles=5" is_open="1" width="100%" height="auto" title="Home page 1" image="home_page_4.jpg"][/ApImage][/ApColumn][/ApRow]\'),
(14, ID_LANG, \'[ApRow form_id="form_23438838882702385" container="container" class="row hidden-sp hidden-xs hidden-sm" bg_config="fullwidth" bg_type="normal" bg_img="background_image.jpg" bg_position="top" bg_repeat="no-repeat" parallax_speed="0.1" parallax_axis="both" parallax_strength="0.5" parallax_rid="0.5" parallax_hoffsets="0.1" parallax_voffsets="0.1" animation="none" animation_delay="2" specific_type="all" active="1" controller_pages="" controller_id=""][ApColumn form_id="form_6898351249806958" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_9183465394653716" animation="none" animation_delay="0.5" is_open="0" width="auto" height="auto" active="1" image="icon_3.png" description="<div class=_APQUOT_topcolumn_APQUOT_>_APENTER_<div class=_APQUOT_title_top_column_APQUOT_><a href=_APQUOT_#_APQUOT_>code</a></div>_APENTER_Follow Prestashop Standards with clean code, user can easily use and change. Our code is easy to read, whether that reader is the original author of the code or somebody else. Our code is easy to extend and refactor, and it’s easy to fix bugs in the code base.</div>"][/ApImage][/ApColumn][ApColumn form_id="form_3571039038455705" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_9798061660060414" animation="none" animation_delay="0.5" is_open="0" width="auto" height="auto" active="1" image="icon2.png" description="<div class=_APQUOT_topcolumn_APQUOT_>_APENTER_<div class=_APQUOT_title_top_column_APQUOT_><a href=_APQUOT_#_APQUOT_>Community</a></div>_APENTER_We are always looking for partners to develop Prestashop Community stronger. Let’s try our module to experience powerful module of prestashop. Apollo Page Builder contains all you need for your site.</div>"][/ApImage][/ApColumn][ApColumn form_id="form_27904010314759605" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_7577818211879335" animation="none" animation_delay="0.5" is_open="0" width="auto" height="auto" active="1" image="icon1.png" description="<div class=_APQUOT_topcolumn_APQUOT_>_APENTER_<div class=_APQUOT_title_top_column_APQUOT_><a href=_APQUOT_#_APQUOT_>Support</a></div>_APENTER_We committed that we always beside you to help you build your site in the best way, we reply all emails within 24 hours. We always focus on Supporting Activities with custom work or tickets .Serving customer is our happiness. Thank you for your trust and use our New Module AP Page Builder.</div>"][/ApImage][/ApColumn][/ApRow]\');';
            $sqlArray[] = 'INSERT INTO `'._DB_PREFIX_.'appagebuilder_lang` (`id_appagebuilder`, `id_lang`, `params`) VALUES
(16, ID_LANG, \'[ApRow form_id="form_8585346754215833" container="producttabs" class="row" bg_position="top" bg_repeat="no-repeat" bg_type="static" parallax_speed="0.1" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id=""][ApColumn form_id="form_5238012482357679" lg="12" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApRawHtml form_id="form_7746149067139077" content_html="<a id=_APQUOT_accodition_APQUOT_ name=_APQUOT_accodition_APQUOT_></a>"][/ApRawHtml][ApRawHtml form_id="form_5437206341677356" content_html="<h1 class=_APQUOT_title-demo_APQUOT_>Accordion</h1>"][/ApRawHtml][ApAccordions form_id="form_8281543082670329" accordion_type="vertical" active_type="showall" active_accordion="1"][ApAccordion form_id="form_5747516099315480" parent_id="accordion_9779187664341524" id="collapse_3627290157553152" title="Accordion 1"][ApProductCarousel form_id="form_37815407715713975" value_by_product_type="1" category_type="all" product_type="new_product" order_way="asc" order_by="position" nb_products="4" carousel_type="owlcarousel" items="4" itemsdesktop="4" itemsdesktopsmall="3" itemstablet="2" itemsmobile="1" itempercolumn="1" autoplay="0" slidespeed="200" stoponhover="0" responsive="0" navigation="0" scrollperpage="0" autoheight="0" mousedrag="0" touchdrag="0" lazyload="false" lazyfollow="0" lazyeffect="fade" pagination="false" paginationnumbers="0" paginationspeed="800" nbitemsperpage="4" nbitemsperline="4" nbitemsperlinetablet="3" nbitemsperlinemobile="2" interval="5000" profile="plist1427203522"][/ApProductCarousel][/ApAccordion][ApAccordion form_id="form_16020949976037898" parent_id="accordion_9779187664341524" id="collapse_1418528102755890" title="Accordion 2"][ApHtml form_id="form_9364289297771386" content_html="<div><p>Nunc in sem quis metus commodo blandit. Etiam lorem odio, varius sit amet eleifend vitae, varius at quam. Aliquam quis metus mauris. Nam quis nunc in libero viverra ornare quis ut magna. Proin varius velit vel urna sagittis congue. Curabitur porta aliquet interdum. Donec quis velit lectus. Ut semper mi vitae nisi ultrices accumsan. Aliquam magna odio, dignissim facilisis aliquam sed, fermentum quis eros. In id nisl a quam lobortis interdum at consequat ligula.</p><p>Quisque gravida ultrices nisl faucibus commodo. Cras a nibh tellus. Etiam tincidunt mi a dui dapibus convallis in in orci. Vivamus ultrices quam vitae nibh aliquet lobortis. Morbi sit amet tristique felis. Aenean tellus nulla, facilisis eget porta non, volutpat at ligula. Praesent eu nisi leo. Proin mollis libero quis enim vehicula aliquet. Quisque tempus, nisi at molestie bibendum, nulla leo dignissim nulla, et dictum magna sapien a orci. Integer ultrices nulla et turpis posuere at rutrum metus sollicitudin. Aenean consequat sagittis lacinia. Praesent mollis tincidunt risus, quis dictum ante scelerisque vel.</p></div>"][/ApHtml][/ApAccordion][ApAccordion form_id="form_13014397808544208" id="collapse-3778209098655756" parent_id="accordion_9779187664341524" title="Accordion 3"][ApHtml form_id="form_8225748898276610" content_html="<div>_APENTER_<p>Nunc in sem quis metus commodo blandit. Etiam lorem odio, varius sit amet eleifend vitae, varius at quam. Aliquam quis metus mauris. Nam quis nunc in libero viverra ornare quis ut magna. Proin varius velit vel urna sagittis congue. Curabitur porta aliquet interdum. Donec quis velit lectus. Ut semper mi vitae nisi ultrices accumsan. Aliquam magna odio, dignissim facilisis aliquam sed, fermentum quis eros. In id nisl a quam lobortis interdum at consequat ligula.</p>_APENTER_<p>Quisque gravida ultrices nisl faucibus commodo. Cras a nibh tellus. Etiam tincidunt mi a dui dapibus convallis in in orci. Vivamus ultrices quam vitae nibh aliquet lobortis. Morbi sit amet tristique felis. Aenean tellus nulla, facilisis eget porta non, volutpat at ligula. Praesent eu nisi leo. Proin mollis libero quis enim vehicula aliquet. Quisque tempus, nisi at molestie bibendum, nulla leo dignissim nulla, et dictum magna sapien a orci. Integer ultrices nulla et turpis posuere at rutrum metus sollicitudin. Aenean consequat sagittis lacinia. Praesent mollis tincidunt risus, quis dictum ante scelerisque vel.</p>_APENTER_</div>"][/ApHtml][/ApAccordion][/ApAccordions][/ApColumn][/ApRow][ApRow form_id="form_3049155504235973" id="alert-column" class="row" bg_position="top" bg_repeat="no-repeat" bg_type="static" parallax_speed="0.1" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id=""][ApColumn form_id="form_3074604213344822" lg="12" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApRawHtml form_id="form_8373772940837227" content_html="<a id=_APQUOT_alert_APQUOT_ name=_APQUOT_alert_APQUOT_></a>"][/ApRawHtml][ApRawHtml form_id="form_4688946868919659" content_html="<h1 class=_APQUOT_title-demo_APQUOT_>Alert</h1>"][/ApRawHtml][ApHtml form_id="form_6158854800373479" content_html="<p>Provide contextual feedback messages for typical user actions with the handful of available and flexible alert messages</p>"][/ApHtml][ApAlert form_id="form_39172648935412215" alert_type="alert-success" content_html="<p>Success! Your message has been sent successfully</p>"][/ApAlert][ApAlert form_id="form_7948960792036731" alert_type="alert-warning" content_html="<p>Warning! There was a problem with your network connection</p>"][/ApAlert][ApAlert form_id="form_7791976853977195" alert_type="alert-info" content_html="<p>Note! Please read the comments carefully</p>"][/ApAlert][ApAlert form_id="form_10127215061592451" alert_type="alert-danger" content_html="<p>Erro! A problem has been occurred while submitting your data</p>"][/ApAlert][/ApColumn][/ApRow][ApRow form_id="form_7323869510367312" class="row" bg_config="fullwidth" bg_type="normal" bg_img="bg_carousel_1.jpg" bg_position="top" bg_repeat="no-repeat" parallax_speed="0.1" parallax_axis="both" parallax_strength="0.5" parallax_rid="0.5" parallax_hoffsets="0.1" parallax_voffsets="0.1" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id=""][ApColumn form_id="form_8113661739777138" class="block_carousel_1" lg="12" md="12" sm="12" xs="12" sp="12" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id=""][ApRawHtml form_id="form_6870685731711666" content_html="<a id=_APQUOT_block_carousel_APQUOT_ name=_APQUOT_block_carousel_APQUOT_></a>"][/ApRawHtml][ApRawHtml form_id="form_2256621063858937" content_html="<h1 class=_APQUOT_title-demo_APQUOT_>Block Category</h1>"][/ApRawHtml][ApBlockCarousel form_id="form_8328098268965098" is_open="0" carousel_type="owlcarousel" items="2" itemsdesktop="2" itemsdesktopsmall="2" itemstablet="2" itemsmobile="1" itempercolumn="1" autoplay="0" slidespeed="200" stoponhover="0" responsive="1" navigation="0" scrollperpage="1" autoheight="0" mousedrag="1" touchdrag="1" lazyload="false" lazyfollow="0" lazyeffect="fade" pagination="true" paginationnumbers="0" paginationspeed="800" nbitemsperpage="5" nbitemsperline="4" nbitemsperlinetablet="3" nbitemsperlinemobile="2" interval="5000" total_slider="4|3|2|1" img_4_1="10.png" descript_4_1="<div class=_APQUOT_content-slider col-lg-12 col-md-12_APQUOT_>_APENTER_    <p>Duis sed odio sit amet nibh vutate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio.....</p>_APENTER_    <div class=_APQUOT_testimonial-item _APQUOT_>_APENTER_        <div class=_APQUOT_content_name_APQUOT_>_APENTER_            <h5>JAMES BOYD</h5>_APENTER_            <p>Creative Manager</p>_APENTER_        </div>_APENTER_    </div>_APENTER_</div>" img_4_2="10.png" descript_4_2="<div class=_APQUOT_content-slider col-lg-12 col-md-12_APQUOT_>_APENTER_    <p>Duis sed odio sit amet nibh vutate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio.....</p>_APENTER_    <div class=_APQUOT_testimonial-item _APQUOT_>_APENTER_        <div class=_APQUOT_content_name_APQUOT_>_APENTER_            <h5>JAMES BOYD</h5>_APENTER_            <p>Creative Manager</p>_APENTER_        </div>_APENTER_    </div>_APENTER_</div>" img_3_1="9.png" descript_3_1="<div class=_APQUOT_content-slider col-lg-12 col-md-12_APQUOT_>_APENTER_    <p>Duis sed odio sit amet nibh vutate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio.....</p>_APENTER_    <div class=_APQUOT_testimonial-item _APQUOT_>_APENTER_        <div class=_APQUOT_content_name_APQUOT_>_APENTER_            <h5>JAMES BOYD</h5>_APENTER_            <p>Creative Manager</p>_APENTER_        </div>_APENTER_    </div>_APENTER_</div>" img_3_2="9.png" descript_3_2="<div class=_APQUOT_content-slider col-lg-12 col-md-12_APQUOT_>_APENTER_    <p>Duis sed odio sit amet nibh vutate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio.....</p>_APENTER_    <div class=_APQUOT_testimonial-item _APQUOT_>_APENTER_        <div class=_APQUOT_content_name_APQUOT_>_APENTER_            <h5>JAMES BOYD</h5>_APENTER_            <p>Creative Manager</p>_APENTER_        </div>_APENTER_    </div>_APENTER_</div>" img_2_1="10.png" descript_2_1="<div class=_APQUOT_content-slider col-lg-12 col-md-12_APQUOT_>_APENTER_    <p>Duis sed odio sit amet nibh vutate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio.....</p>_APENTER_    <div class=_APQUOT_testimonial-item _APQUOT_>_APENTER_        <div class=_APQUOT_content_name_APQUOT_>_APENTER_            <h5>JAMES BOYD</h5>_APENTER_            <p>Creative Manager</p>_APENTER_        </div>_APENTER_    </div>_APENTER_</div>" img_2_2="10.png" descript_2_2="<div class=_APQUOT_content-slider_APQUOT_>_APENTER_    <p>Duis sed odio sit amet nibh vutate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio.....Duis sed odio sit amet nibh vutate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio.....</p>_APENTER_    <div class=_APQUOT_testimonial-item _APQUOT_>_APENTER_        <div class=_APQUOT_content_name_APQUOT_>_APENTER_            <h5>JAMES BOYD</h5>_APENTER_            <p>Creative Manager</p>_APENTER_        </div>_APENTER_    </div>_APENTER_</div>" img_1_1="9.png" descript_1_1="<div class=_APQUOT_content-slider col-lg-12 col-md-12_APQUOT_>_APENTER_    <p>Duis sed odio sit amet nibh vutate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio.....</p>_APENTER_    <div class=_APQUOT_testimonial-item _APQUOT_>_APENTER_        <div class=_APQUOT_content_name_APQUOT_>_APENTER_            <h5>JAMES BOYD</h5>_APENTER_            <p>Creative Manager</p>_APENTER_        </div>_APENTER_    </div>_APENTER_</div>" img_1_2="9.png" descript_1_2="<div class=_APQUOT_content-slider_APQUOT_>_APENTER_    <p>Duis sed odio sit amet nibh vutate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio.....</p>_APENTER_    <div class=_APQUOT_testimonial-item _APQUOT_>_APENTER_        <div class=_APQUOT_content_name_APQUOT_>_APENTER_            <h5>JAMES BOYD</h5>_APENTER_            <p>Creative Manager</p>_APENTER_        </div>_APENTER_    </div>_APENTER_</div>"][/ApBlockCarousel][/ApColumn][/ApRow][ApRow form_id="form_9775179471218376" id="block_links" class="row" bg_position="top" bg_repeat="no-repeat" bg_type="static" parallax_speed="0.1" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id=""][ApColumn form_id="form_7491784028700795" lg="12" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApRawHtml form_id="form_8057619555206390" content_html="<a id=_APQUOT_links_APQUOT_ name=_APQUOT_links_APQUOT_></a>"][/ApRawHtml][ApRawHtml form_id="form_5792688509219064" content_html="<h1 class=_APQUOT_title-demo_APQUOT_>block link</h1>"][/ApRawHtml][/ApColumn][ApColumn form_id="form_7801294971029926" md="6" lg="3" specific_type="" controller_pages="" controller_id=""][ApBlockLink form_id="form_3562109535463975" total_link="6" title_1_1="Specials" link_1_1="#" title_2_1="New products" title_2_2="New products" link_2_1="#" link_2_2="#" title_3_1="Best sellers" title_3_2="Best sellers" link_3_1="#" link_3_2="#" title_4_1="Our stores" title_4_2="Our stores" link_4_1="#" link_4_2="#" title_5_1="Contact us" title_5_2="Contact us" link_5_1="#" link_5_2="#" title_6_1="Sitemap" title_6_2="Sitemap" link_6_1="#" link_6_2="#" name="Information"][/ApBlockLink][/ApColumn][ApColumn form_id="form_16328721556400005" md="6" lg="3" specific_type="" controller_pages="" controller_id=""][ApBlockLink form_id="form_6253642791352882" total_link="4" title_1_1="My orders" link_1_1="#" title_2_1="My credit slips" title_2_2="My credit slips" link_2_1="#" link_2_2="#" title_3_1="My addresses" title_3_2="My addresses" link_3_1="#" link_3_2="#" title_4_1="My personal info" title_4_2="My personal info" link_4_1="#" link_4_2="#" name="My account"][/ApBlockLink][/ApColumn][ApColumn form_id="form_2817281216504847" md="6" lg="3" specific_type="" controller_pages="" controller_id=""][ApBlockLink form_id="form_8999254390977909" total_link="4" title_1_1="My orders" link_1_1="#" title_2_1="My credit slips" title_2_2="My credit slips" link_2_1="#" link_2_2="#" title_3_1="My addresses" title_3_2="My addresses" link_3_1="#" link_3_2="#" title_4_1="My personal info" title_4_2="My personal info" link_4_1="#" link_4_2="#" name="My account"][/ApBlockLink][/ApColumn][ApColumn form_id="form_8319394137041676" md="6" lg="3" specific_type="" controller_pages="" controller_id=""][ApBlockLink form_id="form_4076390962537779" total_link="6" title_1_1="Specials" link_1_1="#" title_2_1="New products" title_2_2="New products" link_2_1="#" link_2_2="#" title_3_1="Best sellers" title_3_2="Best sellers" link_3_1="#" link_3_2="#" title_4_1="Our stores" title_4_2="Our stores" link_4_1="#" link_4_2="#" title_5_1="Contact us" title_5_2="Contact us" link_5_1="#" link_5_2="#" title_6_1="Sitemap" title_6_2="Sitemap" link_6_1="#" link_6_2="#" name="Information"][/ApBlockLink][/ApColumn][/ApRow][ApRow form_id="form_4128395005006670" class="row" bg_position="top" bg_repeat="no-repeat" bg_type="static" parallax_speed="0.1" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id=""][ApColumn form_id="form_21922416232372785" lg="12" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApRawHtml form_id="form_6520071611038430" content_html="<a id=_APQUOT_button_APQUOT_ name=_APQUOT_button_APQUOT_></a>"][/ApRawHtml][ApRawHtml form_id="form_4547194691157237" content_html="<h1 class=_APQUOT_title-demo_APQUOT_>Button</h1>"][/ApRawHtml][ApHtml form_id="form_4382102067399840" content_html="<div>Use any of the available button classes to quickly create a styled button.</div>"][/ApHtml][/ApColumn][ApColumn form_id="form_27290234633930812" md="6" lg="6" specific_type="" controller_pages="" controller_id=""][ApRawHtml form_id="form_7110048225548079" content_html="<div class=_APQUOT_title_button_APQUOT_>Small buttton</div>"][/ApRawHtml][ApButton form_id="form_7761846484054608" button_type="btn-default" button_size="btn-xs" is_block="0" is_blank="0" name="Button"][/ApButton][ApButton form_id="form_27800926395228845" button_type="btn-primary" button_size="btn-xs" is_block="0" is_blank="0" name="Button"][/ApButton][ApButton form_id="form_7717751514876341" button_type="btn-success" button_size="btn-xs" is_block="0" is_blank="0" name="Button"][/ApButton][ApButton form_id="form_7327784493595790" button_type="btn-info" button_size="btn-xs" is_block="0" is_blank="0" name="Button"][/ApButton][ApButton form_id="form_11449370588601312" button_type="btn-warning" button_size="btn-xs" is_block="0" is_blank="0" name="Button"][/ApButton][ApButton form_id="form_6333946792258117" button_type="btn-danger" button_size="btn-xs" is_block="0" is_blank="0" name="Button"][/ApButton][/ApColumn][ApColumn form_id="form_6847141153679525" md="6" lg="6" specific_type="" controller_pages="" controller_id=""][ApRawHtml form_id="form_5172906648416006" content_html="<div class=_APQUOT_title_button_APQUOT_>Small buttton</div>"][/ApRawHtml][ApButton form_id="form_4159049258221491" button_type="btn-default" button_size="btn-sm" is_block="0" is_blank="0" name="Button"][/ApButton][ApButton form_id="form_3255869430877696" button_type="btn-primary" button_size="btn-sm" is_block="0" is_blank="0" name="Button"][/ApButton][ApButton form_id="form_2612906591726933" button_type="btn-success" button_size="btn-sm" is_block="0" is_blank="0" name="Button"][/ApButton][ApButton form_id="form_6953055030295920" button_type="btn-info" button_size="btn-sm" is_block="0" is_blank="0" name="Button"][/ApButton][ApButton form_id="form_26680700611574295" button_type="btn-warning" button_size="btn-sm" is_block="0" is_blank="0" name="Button"][/ApButton][ApButton form_id="form_6695647946112981" button_type="btn-danger" button_size="btn-sm" is_block="0" is_blank="0" name="Button"][/ApButton][/ApColumn][ApColumn form_id="form_22780944312289905" md="6" lg="6" specific_type="" controller_pages="" controller_id=""][ApRawHtml form_id="form_15268779034027995" content_html="<div class=_APQUOT_title_button_APQUOT_> Buttton default</div>"][/ApRawHtml][ApButton form_id="form_9118563628174596" button_type="btn-default" button_size="size-default" is_block="0" is_blank="0" name="Button"][/ApButton][ApButton form_id="form_30187221646628775" button_type="btn-primary" button_size="btn-lg" is_block="0" is_blank="0" name="Button"][/ApButton][ApButton form_id="form_6274780632797976" button_type="btn-success" button_size="btn-lg" is_block="0" is_blank="0" name="Button"][/ApButton][ApButton form_id="form_9775415845202260" button_type="btn-info" button_size="btn-lg" is_block="0" is_blank="0" name="Button"][/ApButton][ApButton form_id="form_14696299827074218" button_type="btn-warning" button_size="btn-lg" is_block="0" is_blank="0" name="Button"][/ApButton][ApButton form_id="form_31148627107622685" button_type="btn-danger" button_size="btn-lg" is_block="0" is_blank="0" name="Button"][/ApButton][/ApColumn][ApColumn form_id="form_1963234972992453" md="6" lg="6" specific_type="" controller_pages="" controller_id=""][ApRawHtml form_id="form_43795960303697625" content_html="<div class=_APQUOT_title_button_APQUOT_>Large buttton</div>"][/ApRawHtml][ApButton form_id="form_22692604513943445" button_type="btn-default" button_size="btn-lg" is_block="0" is_blank="0" name="Button"][/ApButton][ApButton form_id="form_6815542178807429" button_type="btn-primary" button_size="btn-lg" is_block="0" is_blank="0" name="Button"][/ApButton][ApButton form_id="form_5771264344655418" button_type="btn-success" button_size="btn-lg" is_block="0" is_blank="0" name="Button"][/ApButton][ApButton form_id="form_15175703286181188" button_type="btn-info" button_size="btn-lg" is_block="0" is_blank="0" name="Button"][/ApButton][ApButton form_id="form_9026871597400452" button_type="btn-warning" button_size="btn-lg" is_block="0" is_blank="0" name="Button"][/ApButton][ApButton form_id="form_6129819962525899" button_type="btn-danger" button_size="btn-lg" is_block="0" is_blank="0" name="Button"][/ApButton][/ApColumn][/ApRow][ApRow form_id="form_9270110575334278" class="row" bg_config="boxed" bg_type="normal" bg_position="top" bg_repeat="no-repeat" parallax_speed="0.1" parallax_axis="both" parallax_strength="0.5" parallax_rid="0.5" parallax_hoffsets="0.1" parallax_voffsets="0.1" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id=""][ApColumn form_id="form_6594028570481188" lg="12" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApRawHtml form_id="form_9544090414264420" content_html="<a id=_APQUOT_img_of_category_APQUOT_ name=_APQUOT_img_of_category_APQUOT_></a>"][/ApRawHtml][ApRawHtml form_id="form_4473575107504549" content_html="<h1 class=_APQUOT_title-demo_APQUOT_>Images of category</h1>"][/ApRawHtml][/ApColumn][ApColumn form_id="form_3764259615223181" md="4" lg="4" specific_type="" controller_pages="" controller_id=""][ApCategoryImage form_id="form_10336644516060872" categorybox="8,12" category_img="{_APQUOT_7_APQUOT_:_APQUOT_icon_shirt.jpg_APQUOT_,_APQUOT_8_APQUOT_:_APQUOT_icon_shirt.jpg_APQUOT_}" cate_depth="1" orderby="position" showicons="1" limit="5" id_root="2" id_lang="1"][/ApCategoryImage][/ApColumn][ApColumn form_id="form_5113459518420777" md="4" lg="4" specific_type="" controller_pages="" controller_id=""][ApCategoryImage form_id="form_2528801533671713" categorybox="9,10,11" category_img="{_APQUOT_5_APQUOT_:_APQUOT_icon_shirt_2.jpg_APQUOT_,_APQUOT_9_APQUOT_:_APQUOT_icon_shirt_2.jpg_APQUOT_}" cate_depth="1" orderby="position" showicons="1" limit="5" id_root="2" id_lang="1"][/ApCategoryImage][/ApColumn][ApColumn form_id="form_38786546351322725" md="4" lg="4" specific_type="" controller_pages="" controller_id=""][ApCategoryImage form_id="form_6905914243670709" categorybox="9,10,11" category_img="{_APQUOT_6_APQUOT_:_APQUOT_icon_shirt_3.jpg_APQUOT_,_APQUOT_9_APQUOT_:_APQUOT_icon_shirt_3.jpg_APQUOT_}" cate_depth="1" orderby="position" showicons="1" limit="5" id_root="2" id_lang="1"][/ApCategoryImage][/ApColumn][/ApRow][ApRow form_id="form_9376195753339062" class="row" specific_type="" controller_pages="" controller_id=""][ApColumn form_id="form_7136754007424545" lg="12" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApRawHtml form_id="form_39329625390439255" content_html="<a id=_APQUOT_facebook_APQUOT_ name=_APQUOT_facebook_APQUOT_></a>"][/ApRawHtml][ApRawHtml form_id="form_7877714421346107" content_html="<h1 class=_APQUOT_title-demo_APQUOT_>Facebook</h1>"][/ApRawHtml][ApFacebook form_id="form_3800701634190953" page_url="https://www.facebook.com/LeoTheme" border="1" target="dark" show_stream="0" show_faces="1" show_header="0" show_border="0"][/ApFacebook][/ApColumn][/ApRow][ApRow form_id="form_5618860353046015" class="row" specific_type="" controller_pages="" controller_id=""][ApColumn form_id="form_8056318096137253" lg="12" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApRawHtml form_id="form_18814642934528498" content_html="<a id=_APQUOT_font_APQUOT_ name=_APQUOT_font_APQUOT_></a>"][/ApRawHtml][ApRawHtml form_id="form_4537531283440292" content_html="<h1 class=_APQUOT_title-demo_APQUOT_>Font awesome</h1>"][/ApRawHtml][ApFontAwesome form_id="form_8718725767843969" font_name="icon-font" font_type="normal" font_size="icon-2x"][/ApFontAwesome][ApFontAwesome form_id="form_8088667848883682" font_name="icon-bold" font_type="normal" font_size="icon-2x"][/ApFontAwesome][ApFontAwesome form_id="form_12448279009430508" font_name="icon-adjust" font_type="normal" font_size="icon-2x"][/ApFontAwesome][ApFontAwesome form_id="form_8142110289577303" font_name="icon-calendar" font_type="normal" font_size="icon-2x"][/ApFontAwesome][ApFontAwesome form_id="form_9597431616293728" font_name="icon-bookmark-empty" font_type="normal" font_size="icon-2x"][/ApFontAwesome][ApFontAwesome form_id="form_5316660773742451" font_name="icon-bolt" font_type="normal" font_size="icon-2x"][/ApFontAwesome][ApFontAwesome form_id="form_2121454976253815" font_name="icon-book" font_type="normal" font_size="icon-2x"][/ApFontAwesome][ApFontAwesome form_id="form_9018897852372854" font_name="icon-certificate" font_type="normal" font_size="icon-2x"][/ApFontAwesome][ApFontAwesome form_id="form_6393759914590931" font_name="icon-check" font_type="normal" font_size="icon-2x"][/ApFontAwesome][ApFontAwesome form_id="form_3877728595545564" font_name="icon-check-empty" font_type="normal" font_size="icon-2x"][/ApFontAwesome][ApFontAwesome form_id="form_7743164109734833" font_name="icon-comments-alt" font_type="normal" font_size="icon-2x"][/ApFontAwesome][ApFontAwesome form_id="form_3158073848985048" font_name="icon-credit-card" font_type="normal" font_size="icon-2x"][/ApFontAwesome][ApFontAwesome form_id="form_6242249081093866" font_name="icon-thumbs-up-alt" font_type="normal" font_size="icon-2x"][/ApFontAwesome][ApFontAwesome form_id="form_1596768051743067" font_name="icon-thumbs-down-alt" font_type="normal" font_size="icon-2x"][/ApFontAwesome][ApFontAwesome form_id="form_3230079119856299" font_name="icon-truck" font_type="normal" font_size="icon-2x"][/ApFontAwesome][ApFontAwesome form_id="form_20308232733645582" font_name="icon-zoom-in" font_type="normal" font_size="icon-2x"][/ApFontAwesome][ApFontAwesome form_id="form_7833737132509365" font_name="icon-zoom-out" font_type="normal" font_size="icon-2x"][/ApFontAwesome][ApFontAwesome form_id="form_11275580674408442" font_name="icon-angle-left" font_type="normal" font_size="icon-2x"][/ApFontAwesome][ApFontAwesome form_id="form_8792315472049795" font_name="icon-double-angle-left" font_type="normal" font_size="icon-2x"][/ApFontAwesome][ApFontAwesome form_id="form_5552598006336444" font_name="icon-angle-right" font_type="normal" font_size="icon-2x"][/ApFontAwesome][ApFontAwesome form_id="form_9722431128143916" font_name="icon-double-angle-right" font_type="normal" font_size="icon-2x"][/ApFontAwesome][ApFontAwesome form_id="form_18374365346616008" font_name="icon-angle-up" font_type="normal" font_size="icon-2x"][/ApFontAwesome][ApFontAwesome form_id="form_9400772099228614" font_name="icon-double-angle-up" font_type="normal" font_size="icon-2x"][/ApFontAwesome][ApFontAwesome form_id="form_7347857706521625" font_name="icon-angle-down" font_type="normal" font_size="icon-2x"][/ApFontAwesome][ApFontAwesome form_id="form_20848572219060703" font_name="icon-double-angle-down" font_type="normal" font_size="icon-2x"][/ApFontAwesome][ApFontAwesome form_id="form_3828240533721924" font_name="icon-align-center" font_type="normal" font_size="icon-2x"][/ApFontAwesome][ApFontAwesome form_id="form_5532005024124757" font_name="icon-align-justify" font_type="normal" font_size="icon-2x"][/ApFontAwesome][ApFontAwesome form_id="form_9538244804986514" font_name="icon-arrow-down" font_type="normal" font_size="icon-2x"][/ApFontAwesome][ApFontAwesome form_id="form_30410350392364325" font_name="icon-arrow-up" font_type="normal" font_size="icon-2x"][/ApFontAwesome][ApFontAwesome form_id="form_25037128128435155" font_name="icon-arrow-left" font_type="normal" font_size="icon-2x"][/ApFontAwesome][ApFontAwesome form_id="form_9282294693482376" font_name="icon-eye-open" font_type="normal" font_size="icon-2x"][/ApFontAwesome][ApFontAwesome form_id="form_6720816339482913" font_name="icon-smile" font_type="normal" font_size="icon-2x"][/ApFontAwesome][ApFontAwesome form_id="form_3154190529744080" font_name="icon-spinner" font_type="normal" font_size="icon-2x"][/ApFontAwesome][ApFontAwesome form_id="form_1550183727101428" font_name="icon-user" font_type="normal" font_size="icon-2x"][/ApFontAwesome][/ApColumn][/ApRow][ApRow form_id="form_7221411395592504" class="row" bg_config="boxed" bg_type="normal" bg_position="top" bg_repeat="no-repeat" parallax_speed="0.1" parallax_axis="both" parallax_strength="0.5" parallax_rid="0.5" parallax_hoffsets="0.1" parallax_voffsets="0.1" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id=""][ApColumn form_id="form_8437007902216545" lg="12" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApRawHtml form_id="form_4882110288733965" content_html="<a id=_APQUOT_fullslide_APQUOT_ name=_APQUOT_fullslide_APQUOT_></a>"][/ApRawHtml][ApRawHtml form_id="form_5654182122665853" content_html="<h1 class=_APQUOT_title-demo_APQUOT_>Full Slider</h1>"][/ApRawHtml][ApFullSlider form_id="form_11025546851139116" class="container" width="100%" height="350px" interval="2000" display_title="1" display_indicators="1" is_open="0" total_slider="2|1" img_2_1="full-1.jpg" img_2_2="full-1.jpg" img_1_1="full-2.jpg" img_1_2="full-2.jpg"][/ApFullSlider][/ApColumn][/ApRow][ApRow form_id="form_8773874456454320" class="row" specific_type="" controller_pages="" controller_id=""][ApColumn form_id="form_6920841289444854" lg="12" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApRawHtml form_id="form_7689178820022591" content_html="<a id=_APQUOT_googlemap_APQUOT_ name=_APQUOT_googlemap_APQUOT_></a>"][/ApRawHtml][ApRawHtml form_id="form_5073622668859955" content_html="<h1 class=_APQUOT_title-demo_APQUOT_>Google map</h1>"][/ApRawHtml][ApGmap form_id="form_3193367883519104" zoom="11" width="100%" height="300px" display_store="1" is_display_list="0"][/ApGmap][/ApColumn][/ApRow][ApRow form_id="form_17207080040905985" class="row" bg_position="top" bg_repeat="no-repeat" bg_type="static" parallax_speed="0.1" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id=""][ApColumn form_id="form_5390549010286369" lg="12" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApRawHtml form_id="form_4789325477362414" content_html="<a id=_APQUOT_html_APQUOT_ name=_APQUOT_html_APQUOT_></a>"][/ApRawHtml][ApRawHtml form_id="form_5714098702349432" content_html="<h1 class=_APQUOT_title-demo_APQUOT_>Html</h1>"][/ApRawHtml][/ApColumn][ApColumn form_id="form_6133066194670095" md="4" lg="4" specific_type="" controller_pages="" controller_id=""][ApHtml form_id="form_9873963552955380" content_html="<h1><strong>heading</strong></h1><p>Curabitur porta aliquet interdum. Donec quis velit lectus. Ut semper mi vitae nisi ultrices accumsan. Aliquam magna odio, dignissim facilisis aliquam sed, fermentum quis eros.Curabitur porta aliquet interdum. Donec quis velit lectus. Ut semper mi vitae nisi ultrices accumsan. Aliquam magna odio, dignissim facilisis aliquam sed, fermentum quis eros.</p>"][/ApHtml][/ApColumn][ApColumn form_id="form_9909484352020248" md="4" lg="4" specific_type="" controller_pages="" controller_id=""][ApHtml form_id="form_18300436605118945" content_html="<h1><strong>heading</strong></h1><p>Curabitur porta aliquet interdum. Donec quis velit lectus. Ut semper mi vitae nisi ultrices accumsan. Aliquam magna odio, dignissim facilisis aliquam sed, fermentum quis eros.Curabitur porta aliquet interdum. Donec quis velit lectus. Ut semper mi vitae nisi ultrices accumsan. Aliquam magna odio, dignissim facilisis aliquam sed, fermentum quis eros.</p>"][/ApHtml][/ApColumn][ApColumn form_id="form_5716995979230714" md="4" lg="4" specific_type="" controller_pages="" controller_id=""][ApHtml form_id="form_9644165779835104" content_html="<h1><strong>heading</strong></h1><p>Curabitur porta aliquet interdum. Donec quis velit lectus. Ut semper mi vitae nisi ultrices accumsan. Aliquam magna odio, dignissim facilisis aliquam sed, fermentum quis eros.Curabitur porta aliquet interdum. Donec quis velit lectus. Ut semper mi vitae nisi ultrices accumsan. Aliquam magna odio, dignissim facilisis aliquam sed, fermentum quis eros.</p>"][/ApHtml][/ApColumn][/ApRow][ApRow form_id="form_18406027004799342" class="row" bg_position="top" bg_repeat="no-repeat" bg_type="static" parallax_speed="0.1" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id=""][ApColumn form_id="form_7348277626507205" id="image_single" lg="12" md="12" sm="12" xs="12" sp="12" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id=""][ApRawHtml form_id="form_8038299618429322" content_html="<a id=_APQUOT_images_APQUOT_ name=_APQUOT_images_APQUOT_></a>"][/ApRawHtml][ApRawHtml form_id="form_7247147512859209" content_html="<h1 class=_APQUOT_title-demo_APQUOT_>Images</h1>"][/ApRawHtml][ApImage form_id="form_4347294178990024" animation="none" animation_delay="0.5" is_open="0" width="100%" height="350px" image="img_slider-12.jpg"][/ApImage][/ApColumn][/ApRow][ApRow form_id="form_5090784147234008" class="row" bg_position="top" bg_repeat="no-repeat" bg_type="static" parallax_speed="0.1" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id=""][ApColumn form_id="form_6584322882545513" lg="12" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApRawHtml form_id="form_7039528861009542" content_html="<a id=_APQUOT_imagesgallery_APQUOT_ name=_APQUOT_imagesgallery_APQUOT_></a>"][/ApRawHtml][ApRawHtml form_id="form_7103804041942916" content_html="<h1 class=_APQUOT_title-demo_APQUOT_>images gallery</h1>"][/ApRawHtml][/ApColumn][ApColumn form_id="form_4362582104679210" md="12" lg="12" specific_type="" controller_pages="" controller_id=""][ApImageGallery form_id="form_871506908152599" limit="12" columns="4" path="themes/default-bootstrap/img/modules/appagebuilder/gallery"][/ApImageGallery][/ApColumn][/ApRow][ApRow form_id="form_6432259353677033" class="row" bg_position="top" bg_repeat="no-repeat" bg_type="static" parallax_speed="0.1" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id=""][ApColumn form_id="form_26381795311727755" lg="12" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApRawHtml form_id="form_10584736587032769" content_html="<a id=_APQUOT_imagesgalleryproduct_APQUOT_ name=_APQUOT_imagesgalleryproduct_APQUOT_></a>"][/ApRawHtml][ApRawHtml form_id="form_11249505139578686" content_html="<h1 class=_APQUOT_title-demo_APQUOT_>Images gallery product</h1>"][/ApRawHtml][/ApColumn][ApColumn form_id="form_7689618113314169" md="12" lg="4" specific_type="" controller_pages="" controller_id=""][ApImageGalleryProduct form_id="form_8155954642315267" ip_source="ip_pcategories" categorybox="2,3,4,5,6,7,8,9,10,11,12,13" smallimage="cart_default" thickimage="thickbox_default" limit="6" columns="3"][/ApImageGalleryProduct][/ApColumn][ApColumn form_id="form_30554154218634735" md="12" lg="4" specific_type="" controller_pages="" controller_id=""][ApImageGalleryProduct form_id="form_5825399546975496" ip_source="ip_pcategories" categorybox="2,3,4,5,6,7,8,9,10,11,12,13" smallimage="cart_default" thickimage="thickbox_default" limit="6" columns="3"][/ApImageGalleryProduct][/ApColumn][ApColumn form_id="form_6810698288634015" md="12" lg="4" specific_type="" controller_pages="" controller_id=""][ApImageGalleryProduct form_id="form_32628396330811235" ip_source="ip_pcategories" categorybox="2,3,4,5,6,7,8,9,10,11,12,13" smallimage="cart_default" thickimage="thickbox_default" limit="6" columns="3"][/ApImageGalleryProduct][/ApColumn][/ApRow][ApRow form_id="form_3964761055039384" class="row" specific_type="" controller_pages="" controller_id=""][ApColumn form_id="form_981953357776770" lg="12" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApRawHtml form_id="form_5110335943317708" content_html="<a id=_APQUOT_lastblog_APQUOT_ name=_APQUOT_lastblog_APQUOT_></a>"][/ApRawHtml][ApRawHtml form_id="form_1854511766700293" content_html="<h1 class=_APQUOT_title-demo_APQUOT_>Last blog</h1>"][/ApRawHtml][ApBlog form_id="form_21299146710425185" chk_cat="3,4" bleoblogs_show="1" show_title="1" show_desc="1" bleoblogs_sima="1" bleoblogs_saut="1" bleoblogs_scat="1" bleoblogs_scre="1" bleoblogs_scoun="1" bleoblogs_shits="1" order_way="asc" order_by="id_leoblogcat" nb_blogs="10" carousel_type="owlcarousel" items="4" itemsdesktop="4" itemsdesktopsmall="3" itemstablet="2" itemsmobile="1" itempercolumn="1" autoplay="0" slidespeed="200" stoponhover="0" responsive="1" navigation="1" scrollperpage="0" autoheight="0" mousedrag="1" touchdrag="1" lazyload="false" lazyfollow="0" lazyeffect="fade" pagination="false" paginationnumbers="0" paginationspeed="800" nbitemsperpage="12" nbitemsperline="4" nbitemsperlinetablet="3" nbitemsperlinemobile="2" interval="5000"][/ApBlog][/ApColumn][/ApRow][ApRow form_id="form_8101274901570509" class="row" specific_type="" controller_pages="" controller_id=""][ApColumn form_id="form_7621188294493964" lg="12" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApRawHtml form_id="form_35859537975708294" content_html="<a id=_APQUOT_manu_APQUOT_ name=_APQUOT_manu_APQUOT_></a>"][/ApRawHtml][ApRawHtml form_id="form_23045066926689615" content_html="<h1 class=_APQUOT_title-demo_APQUOT_>Manufactures carousel</h1>"][/ApRawHtml][ApManuFacturersCarousel form_id="form_2896390927921237" imagetype="medium_default" order_way="asc" order_by="position" manu_limit="10" carousel_type="owlcarousel" items="6" itemsdesktop="6" itemsdesktopsmall="4" itemstablet="2" itemsmobile="1" itempercolumn="1" autoplay="0" slidespeed="200" stoponhover="1" responsive="1" navigation="1" scrollperpage="1" autoheight="1" mousedrag="1" touchdrag="1" lazyload="false" lazyfollow="0" lazyeffect="fade" pagination="false" paginationnumbers="false" paginationspeed="800" nbitemsperpage="6" nbitemsperline="7" nbitemsperlinetablet="5" nbitemsperlinemobile="2" interval="5000"][/ApManuFacturersCarousel][/ApColumn][/ApRow][ApRow form_id="form_11843758338609912" container="producttabs" class="row" bg_position="top" bg_repeat="no-repeat" bg_type="static" parallax_speed="0.1" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id=""][ApColumn form_id="form_2161554866141544" lg="12" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApRawHtml form_id="form_5740373462694530" content_html="<a id=_APQUOT_carousel_APQUOT_ name=_APQUOT_carousel_APQUOT_></a>"][/ApRawHtml][ApRawHtml form_id="form_2829389094561232" content_html="<h1 class=_APQUOT_title-demo_APQUOT_>Product carousel</h1>"][/ApRawHtml][ApProductCarousel form_id="form_9773593981064660" value_by_product_type="1" categorybox="8" category_type="all" product_type="home_featured" order_way="asc" order_by="position" nb_products="10" carousel_type="owlcarousel" items="4" itemsdesktop="4" itemsdesktopsmall="3" itemstablet="2" itemsmobile="1" itempercolumn="1" autoplay="0" slidespeed="200" stoponhover="false" responsive="true" navigation="false" scrollperpage="false" autoheight="false" mousedrag="true" touchdrag="true" lazyload="false" lazyfollow="false" lazyeffect="fade" pagination="false" paginationnumbers="false" paginationspeed="800" nbitemsperpage="4" nbitemsperline="4" nbitemsperlinetablet="3" nbitemsperlinemobile="2" interval="5000" profile="plist1427203522"][/ApProductCarousel][/ApColumn][/ApRow][ApRow form_id="form_7769305128484741" class="row" specific_type="" controller_pages="" controller_id=""][ApColumn form_id="form_4187338305517809" lg="12" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApRawHtml form_id="form_4724929758736365" content_html="<a id=_APQUOT_rawhtml_APQUOT_ name=_APQUOT_rawhtml_APQUOT_></a>"][/ApRawHtml][ApRawHtml form_id="form_7667181012157963" content_html="<h1 class=_APQUOT_title-demo_APQUOT_>Raw Html</h1>"][/ApRawHtml][ApRawHtml form_id="form_21347361098984792" content_html="<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut Learn More. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>"][/ApRawHtml][/ApColumn][/ApRow][ApRow form_id="form_5202506648464359" container="producttabs" class="row" bg_position="top" bg_repeat="no-repeat" bg_type="static" parallax_speed="0.1" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id=""][ApColumn form_id="form_9997946918302156" lg="12" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApRawHtml form_id="form_7980838549466270" content_html="<a id=_APQUOT_tab_APQUOT_ name=_APQUOT_tab_APQUOT_></a>"][/ApRawHtml][ApRawHtml form_id="form_6989373090792037" content_html="<h1 class=_APQUOT_title-demo_APQUOT_>Tab</h1>"][/ApRawHtml][ApTabs form_id="form_9186103373053606" tab_type="tabs-top" active_tab="1" fade_effect="0"][ApTab form_id="form_8032294514593367" id="tab_8411619565919671" css_class=" " title="New Tab"][ApProductCarousel form_id="form_6817656939884363" value_by_product_type="1" category_type="all" product_type="new_product" order_way="asc" order_by="position" nb_products="10" carousel_type="owlcarousel" items="4" itemsdesktop="4" itemsdesktopsmall="3" itemstablet="2" itemsmobile="1" itempercolumn="1" autoplay="0" slidespeed="200" stoponhover="0" responsive="1" navigation="0" scrollperpage="0" autoheight="0" mousedrag="1" touchdrag="1" lazyload="false" lazyfollow="0" lazyeffect="fade" pagination="false" paginationnumbers="0" paginationspeed="800" nbitemsperpage="12" nbitemsperline="4" nbitemsperlinetablet="3" nbitemsperlinemobile="2" interval="5000" profile="plist1427203522"][/ApProductCarousel][/ApTab][ApTab form_id="form_18354523326642178" id="tab_6821813050694700" css_class=" " title="New Tab"][ApProductCarousel form_id="form_9140255712504560" value_by_product_type="1" category_type="all" product_type="best_sellers" order_way="asc" order_by="position" nb_products="10" carousel_type="owlcarousel" items="4" itemsdesktop="4" itemsdesktopsmall="3" itemstablet="2" itemsmobile="1" itempercolumn="1" autoplay="0" slidespeed="200" stoponhover="0" responsive="1" navigation="0" scrollperpage="0" autoheight="0" mousedrag="1" touchdrag="1" lazyload="false" lazyfollow="0" lazyeffect="fade" pagination="false" paginationnumbers="0" paginationspeed="800" nbitemsperpage="12" nbitemsperline="4" nbitemsperlinetablet="3" nbitemsperlinemobile="2" interval="5000" profile="plist1427203522"][/ApProductCarousel][/ApTab][/ApTabs][/ApColumn][/ApRow][ApRow form_id="form_14192605093070022" class="row" bg_position="top" bg_repeat="no-repeat" bg_type="static" parallax_speed="0.1" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id=""][ApColumn form_id="form_8761962614515855" lg="12" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApRawHtml form_id="form_36106340490119385" content_html="<a id=_APQUOT_twitter_APQUOT_ name=_APQUOT_twitter_APQUOT_></a>"][/ApRawHtml][ApRawHtml form_id="form_14501641595129055" content_html="<h1 class=_APQUOT_title-demo_APQUOT_>twitter</h1> "][/ApRawHtml][ApTwitter form_id="form_7302567343861693" twidget_id="578806287158251521" count="2" username="prestashop" border_color="#000000" link_color="#000000" text_color="#000000" name_color="#000000" mail_color="#000000" width="180" height="200" transparent="1" show_replies="1" show_header="1" show_footer="0" show_border="1" show_scrollbar="1"][/ApTwitter][/ApColumn][/ApRow][ApRow form_id="form_7006825989085507" class="row" bg_position="top" bg_repeat="no-repeat" bg_type="static" parallax_speed="0.1" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id=""][ApColumn form_id="form_9687528709415909" lg="12" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApRawHtml form_id="form_9548869740507330" content_html="<a id=_APQUOT_video_APQUOT_ name=_APQUOT_video_APQUOT_></a>"][/ApRawHtml][ApRawHtml form_id="form_5842111094654301" content_html="<h1 class=_APQUOT_title-demo_APQUOT_>video</h1>"][/ApRawHtml][ApVideo form_id="form_28296285235789215" content_html="<embed width=_APQUOT_1190_APQUOT_ height=_APQUOT_500_APQUOT_src=_APQUOT_http://www.youtube.com/v/iZoR21juRzs_APQUOT_type=_APQUOT_application/x-shockwave-flash_APQUOT_></embed>" align="center"][/ApVideo][/ApColumn][/ApRow]\');';
            $sqlArray[] = 'INSERT INTO `'._DB_PREFIX_.'appagebuilder_lang` (`id_appagebuilder`, `id_lang`, `params`) VALUES
(24, ID_LANG, \'[ApRow form_id="form_2883442194932871" class="row" specific_type="" controller_pages="" controller_id=""][ApColumn form_id="form_7190751546794349" lg="12" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApFullSlider form_id="form_7064697112505045" class="container" width="100%" height="600px" interval="2000" display_title="1" display_indicators="1" is_open="0" total_slider="2|1" img_2_1="slider_1.jpg" descript_2_1="<h3>slide show full screen</h3>_APENTER_<p>Discover the collection</p>" img_1_1="slider_1.jpg" descript_1_1="<h3>slide show full screen</h3>_APENTER_<p>Discover the collection</p>"][/ApFullSlider][/ApColumn][/ApRow]\');';
            $sqlArray[] = 'INSERT INTO `'._DB_PREFIX_.'appagebuilder_lang` (`id_appagebuilder`, `id_lang`, `params`) VALUES
(26, ID_LANG, \'[ApRow form_id="form_4848519753536623" container="producttabs" class="row" bg_position="top" bg_repeat="no-repeat" bg_type="static" parallax_speed="0.1" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id=""][ApColumn form_id="form_4146673008330306" lg="12" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApTabs form_id="form_7910771389680813" class="" tab_type="tabs-top" active_tab="1" fade_effect="0" override_folder="" title=""][ApTab form_id="form_8455584876973514" id="tab_9918258505596682" css_class=" " override_folder="" title="Feature"][ApProductCarousel form_id="form_5624428927090441" value_by_product_type="1" category_type="all" product_type="new_product" order_way="asc" order_by="position" nb_products="10" carousel_type="owlcarousel" items="4" itemsdesktop="4" itemsdesktopsmall="3" itemstablet="2" itemsmobile="1" itempercolumn="1" autoplay="0" slidespeed="200" stoponhover="0" responsive="1" navigation="0" scrollperpage="0" autoheight="0" mousedrag="1" touchdrag="1" lazyload="false" lazyfollow="0" lazyeffect="fade" pagination="false" paginationnumbers="0" paginationspeed="800" nbitemsperpage="12" nbitemsperline="4" nbitemsperlinetablet="3" nbitemsperlinemobile="2" interval="5000" profile="plist1427203522"][/ApProductCarousel][/ApTab][ApTab form_id="form_4640968606134570" id="tab_26802568404962275" css_class=" " override_folder="" title="New product"][ApProductCarousel form_id="form_42079568528426155" value_by_product_type="1" category_type="all" product_type="best_sellers" order_way="asc" order_by="position" nb_products="10" carousel_type="owlcarousel" items="4" itemsdesktop="4" itemsdesktopsmall="3" itemstablet="2" itemsmobile="1" itempercolumn="1" autoplay="0" slidespeed="200" stoponhover="0" responsive="1" navigation="0" scrollperpage="0" autoheight="0" mousedrag="1" touchdrag="1" lazyload="false" lazyfollow="0" lazyeffect="false" pagination="false" paginationnumbers="0" paginationspeed="800" nbitemsperpage="12" nbitemsperline="4" nbitemsperlinetablet="3" nbitemsperlinemobile="2" interval="5000" profile="plist1427203522"][/ApProductCarousel][/ApTab][/ApTabs][/ApColumn][/ApRow][ApRow form_id="form_18594450084863915" class="row" bg_config="fullwidth" bg_type="normal" bg_img="bg_testimonial.jpg" bg_position="50% 0" bg_repeat="repeat-x" parallax_speed="0.1" parallax_axis="both" parallax_strength="0.5" parallax_rid="0.5" parallax_hoffsets="0.1" parallax_voffsets="0.1" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id=""][ApColumn form_id="form_42072219187667515" class="Clients_say" lg="12" md="12" sm="12" xs="12" sp="12" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id="" title="clients say"][ApBlockCarousel form_id="form_7463290721356298" is_open="0" carousel_type="owlcarousel" items="2" itemsdesktop="2" itemsdesktopsmall="3" itemstablet="2" itemsmobile="1" itempercolumn="1" autoplay="0" slidespeed="200" stoponhover="0" responsive="1" navigation="0" scrollperpage="1" autoheight="0" mousedrag="1" touchdrag="1" lazyload="false" lazyfollow="0" lazyeffect="fade" pagination="true" paginationnumbers="0" paginationspeed="800" nbitemsperpage="2" nbitemsperline="2" nbitemsperlinetablet="2" nbitemsperlinemobile="2" interval="5000" total_slider="4|3|2|1" img_4_1="10.png" descript_4_1="<div class=_APQUOT_content-slider col-lg-12 col-md-12_APQUOT_>_APENTER_    <p>Duis sed odio sit amet nibh vutate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio.....</p>_APENTER_    <div class=_APQUOT_testimonial-item _APQUOT_>_APENTER_        <div class=_APQUOT_content_name_APQUOT_>_APENTER_            <h5>JAMES BOYD</h5>_APENTER_            <p>Creative Manager</p>_APENTER_        </div>_APENTER_    </div>_APENTER_</div>" img_4_2="10.png" descript_4_2="<div class=_APQUOT_content-slider col-lg-12 col-md-12_APQUOT_>_APENTER_    <p>Duis sed odio sit amet nibh vutate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio.....</p>_APENTER_    <div class=_APQUOT_testimonial-item _APQUOT_>_APENTER_        <div class=_APQUOT_content_name_APQUOT_>_APENTER_            <h5>JAMES BOYD</h5>_APENTER_            <p>Creative Manager</p>_APENTER_        </div>_APENTER_    </div>_APENTER_</div>" img_3_1="9.png" descript_3_1="<div class=_APQUOT_content-slider col-lg-12 col-md-12_APQUOT_>_APENTER_    <p>Duis sed odio sit amet nibh vutate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio.....</p>_APENTER_    <div class=_APQUOT_testimonial-item _APQUOT_>_APENTER_        <div class=_APQUOT_content_name_APQUOT_>_APENTER_            <h5>JAMES BOYD</h5>_APENTER_            <p>Creative Manager</p>_APENTER_        </div>_APENTER_    </div>_APENTER_</div>" img_3_2="9.png" descript_3_2="<div class=_APQUOT_content-slider col-lg-12 col-md-12_APQUOT_>_APENTER_    <p>Duis sed odio sit amet nibh vutate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio.....</p>_APENTER_    <div class=_APQUOT_testimonial-item _APQUOT_>_APENTER_        <div class=_APQUOT_content_name_APQUOT_>_APENTER_            <h5>JAMES BOYD</h5>_APENTER_            <p>Creative Manager</p>_APENTER_        </div>_APENTER_    </div>_APENTER_</div>" img_2_1="10.png" descript_2_1="<div class=_APQUOT_content-slider col-lg-12 col-md-12_APQUOT_>_APENTER_    <p>Duis sed odio sit amet nibh vutate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio.....</p>_APENTER_    <div class=_APQUOT_testimonial-item _APQUOT_>_APENTER_        <div class=_APQUOT_content_name_APQUOT_>_APENTER_            <h5>JAMES BOYD</h5>_APENTER_            <p>Creative Manager</p>_APENTER_        </div>_APENTER_    </div>_APENTER_</div>" img_2_2="/prestashop/appagebuilder/themes/default-bootstrap/img/modules/appagebuilder/images/10.png" descript_2_2="<div class=_APQUOT_content-slider_APQUOT_>_APENTER_    <p>Duis sed odio sit amet nibh vutate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio.....</p>_APENTER_    <div class=_APQUOT_testimonial-item _APQUOT_>_APENTER_        <div class=_APQUOT_content_name_APQUOT_>_APENTER_            <h5>JAMES BOYD</h5>_APENTER_            <p>Creative Manager</p>_APENTER_        </div>_APENTER_    </div>_APENTER_</div>" img_1_1="9.png" descript_1_1="<div class=_APQUOT_content-slider col-lg-12 col-md-12_APQUOT_>_APENTER_    <p>Duis sed odio sit amet nibh vutate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio.....</p>_APENTER_    <div class=_APQUOT_testimonial-item _APQUOT_>_APENTER_        <div class=_APQUOT_content_name_APQUOT_>_APENTER_            <h5>JAMES BOYD</h5>_APENTER_            <p>Creative Manager</p>_APENTER_        </div>_APENTER_    </div>_APENTER_</div>" img_1_2="/prestashop/appagebuilder/themes/default-bootstrap/img/modules/appagebuilder/images/10.png" descript_1_2="<div class=_APQUOT_content-slider_APQUOT_>_APENTER_    <p>Duis sed odio sit amet nibh vutate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio.....</p>_APENTER_    <div class=_APQUOT_testimonial-item _APQUOT_>_APENTER_        <div class=_APQUOT_content_name_APQUOT_>_APENTER_            <h5>JAMES BOYD</h5>_APENTER_            <p>Creative Manager</p>_APENTER_        </div>_APENTER_    </div>_APENTER_</div>"][/ApBlockCarousel][/ApColumn][/ApRow][ApRow form_id="form_9579456596201572" class="row" specific_type="" controller_pages="" controller_id=""][ApColumn form_id="form_33630584935045845" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_4469853751561933" animation="none" animation_delay="0.5" is_open="0" width="100%" height="auto" image="banner_1.jpg"][/ApImage][/ApColumn][ApColumn form_id="form_7122986860150515" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_7654500147629869" animation="none" animation_delay="0.5" is_open="0" width="100%" height="auto" image="banner_2.jpg"][/ApImage][/ApColumn][ApColumn form_id="form_2613947967578299" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_5906702140391149" animation="none" animation_delay="0.5" is_open="0" width="100%" height="auto" image="banner_3.jpg"][/ApImage][/ApColumn][/ApRow][ApRow form_id="form_5218241744726541" class="row" specific_type="" controller_pages="" controller_id=""][ApColumn form_id="form_5675876889863356" lg="6" md="12" sm="12" xs="12" sp="12" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id="" title="about company"][ApImage form_id="form_3811789261194750" animation="none" animation_delay="0.5" is_open="0" width="100%" height="auto" image="about.jpg" description="<p style=_APQUOT_padding-top: 10px;_APQUOT_>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut Learn More. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua</p>"][/ApImage][/ApColumn][ApColumn form_id="form_30025332722741975" lg="6" md="12" sm="12" xs="12" sp="12" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id="" title="over service"][ApAccordions form_id="form_19063665757564115" accordion_type="vertical" active_type="hideall" active_accordion="1"][ApAccordion form_id="form_1953756598833617" parent_id="accordion_11053861738961591" id="collapse_3310489185697999" title="Accordion 1"][ApHtml form_id="form_7295912035367075" content_html="<div>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut Learn More. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</div>"][/ApHtml][/ApAccordion][ApAccordion form_id="form_6316649160891440" parent_id="accordion_11053861738961591" id="collapse_9248586414925422" title="Accordion 2"][ApHtml form_id="form_7079606311496173" content_html="<div>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut Learn More. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</div>"][/ApHtml][/ApAccordion][ApAccordion form_id="form_6930646201698389" parent_id="accordion_11053861738961591" id="collapse-9449849533019866" title="New Accordion"][ApHtml form_id="form_6074953807164384" content_html="<div>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut Learn More. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</div>"][/ApHtml][/ApAccordion][/ApAccordions][/ApColumn][/ApRow][ApRow form_id="form_4407624977962111" class="row" bg_config="boxed" bg_type="normal" bg_position="top" bg_repeat="no-repeat" parallax_speed="0.1" parallax_axis="both" parallax_strength="0.5" parallax_rid="0.5" parallax_hoffsets="0.1" parallax_voffsets="0.1" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id=""][ApColumn form_id="form_8185824338195259" lg="12" md="12" sm="12" xs="12" sp="12" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id="" title="from of blog"][ApBlog form_id="form_8930254227539089" bleoblogs_show="0" show_title="1" show_desc="1" bleoblogs_sima="1" bleoblogs_saut="0" bleoblogs_scat="0" bleoblogs_scre="1" bleoblogs_scoun="0" bleoblogs_shits="0" order_way="desc" order_by="id_leoblog_blog" nb_blogs="10" carousel_type="owlcarousel" items="2" itemsdesktop="2" itemsdesktopsmall="2" itemstablet="2" itemsmobile="1" itempercolumn="1" autoplay="0" slidespeed="200" stoponhover="0" responsive="1" navigation="1" scrollperpage="0" autoheight="0" mousedrag="1" touchdrag="1" lazyload="false" lazyfollow="0" lazyeffect="fade" pagination="false" paginationnumbers="0" paginationspeed="800" nbitemsperpage="2" nbitemsperline="2" nbitemsperlinetablet="2" nbitemsperlinemobile="2" interval="5000"][/ApBlog][/ApColumn][/ApRow][ApRow form_id="form_38698537477627575" class="row" bg_position="top" bg_repeat="no-repeat" bg_type="static" parallax_speed="0.1" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id=""][ApColumn form_id="form_38656319940576575" lg="12" md="12" sm="12" xs="12" sp="12" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id="" title="our brand"][ApManuFacturersCarousel form_id="form_4671631948954313" class="" value_by_manufacture="0" manuselect="1,2,3,4,5,6,7" imagetype="small_default" order_way="asc" order_by="position" manu_limit="10" carousel_type="owlcarousel" items="5" itemsdesktop="5" itemsdesktopsmall="5" itemstablet="2" itemsmobile="1" itemscustom="" itempercolumn="1" autoplay="0" slidespeed="200" stoponhover="0" responsive="1" navigation="0" scrollperpage="0" autoheight="0" mousedrag="1" touchdrag="1" lazyload="false" lazyfollow="0" lazyeffect="fade" pagination="false" paginationnumbers="0" paginationspeed="800" nbitemsperpage="6" nbitemsperline="6" nbitemsperlinetablet="3" nbitemsperlinemobile="2" interval="5000" override_folder="" title=""][/ApManuFacturersCarousel][/ApColumn][/ApRow][ApRow form_id="form_8166799501009995" class="row Custome_bottom" bg_position="top" bg_repeat="no-repeat" bg_type="static" parallax_speed="0.1" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id=""][ApColumn form_id="form_34439831263826855" lg="6" md="12" sm="12" xs="12" sp="12" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id=""][ApRawHtml form_id="form_5601399646484134" content_html="<div class=_APQUOT_box-outer_APQUOT_>_APENTER__APTAB_<div class=_APQUOT_row_APQUOT_>_APENTER__APTAB__APTAB_<div class=_APQUOT_col-lg-6 col-md-6 col-sm-6 col-xs-12 column_APQUOT_>_APENTER__APTAB__APTAB__APTAB_<div class=_APQUOT_icon_custom ImageWrapper chrome-fix_APQUOT_><span class=_APQUOT_icon-name icon-truck_APQUOT_> </span>_APENTER__APTAB__APTAB__APTAB__APTAB_<div class=_APQUOT_description_APQUOT_>_APENTER__APTAB__APTAB__APTAB__APTAB__APTAB_<p class=_APQUOT_shippingg_APQUOT_>Most Orders Usually Ship within 24 Hours</p>_APENTER__APTAB__APTAB__APTAB__APTAB__APTAB_</div>_APENTER__APTAB__APTAB__APTAB__APTAB_</div>_APENTER__APTAB__APTAB__APTAB_<div class=_APQUOT_ImageOverlayC_APQUOT_> </div>_APENTER__APTAB__APTAB_</div>_APENTER__APTAB__APTAB_<div class=_APQUOT_col-lg-6 col-md-6 col-sm-6 col-xs-12 column_APQUOT_>_APENTER__APTAB__APTAB__APTAB_<div class=_APQUOT_icon_custom_APQUOT_><span class=_APQUOT_icon-name icon-reply-all_APQUOT_> </span>_APENTER__APTAB__APTAB__APTAB__APTAB_<div class=_APQUOT_description_APQUOT_>_APENTER__APTAB__APTAB__APTAB__APTAB__APTAB_<p class=_APQUOT_gift_APQUOT_>100% Money back</p>_APENTER__APTAB__APTAB__APTAB__APTAB__APTAB__APENTER__APTAB__APTAB__APTAB__APTAB_</div>_APENTER__APTAB__APTAB__APTAB_</div>_APENTER__APTAB__APTAB_</div>_APENTER__APTAB_</div>_APENTER_</div>"][/ApRawHtml][ApRawHtml form_id="form_34621913138658205" content_html="<div class=_APQUOT_box-outer_APQUOT_>_APENTER__APTAB_<div class=_APQUOT_row_APQUOT_>_APENTER__APTAB__APTAB_<div class=_APQUOT_col-lg-6 col-md-6 col-sm-6 col-xs-12 column_APQUOT_>_APENTER__APTAB__APTAB__APTAB_<div class=_APQUOT_icon_custom ImageWrapper chrome-fix_APQUOT_><span class=_APQUOT_icon-name icon-phone_APQUOT_> </span>_APENTER__APTAB__APTAB__APTAB__APTAB_<div class=_APQUOT_description_APQUOT_>_APENTER__APTAB__APTAB__APTAB__APTAB__APTAB_<p class=_APQUOT_shippingg_APQUOT_>support</p>_APENTER__APTAB__APTAB__APTAB__APTAB__APTAB_</div>_APENTER__APTAB__APTAB__APTAB__APTAB_</div>_APENTER__APTAB__APTAB__APTAB_<div class=_APQUOT_ImageOverlayC_APQUOT_> </div>_APENTER__APTAB__APTAB_</div>_APENTER__APTAB__APTAB_<div class=_APQUOT_col-lg-6 col-md-6 col-sm-6 col-xs-12 column_APQUOT_>_APENTER__APTAB__APTAB__APTAB_<div class=_APQUOT_icon_custom_APQUOT_><span class=_APQUOT_icon-name icon-money_APQUOT_> </span>_APENTER__APTAB__APTAB__APTAB__APTAB_<div class=_APQUOT_description_APQUOT_>_APENTER__APTAB__APTAB__APTAB__APTAB__APTAB_<p class=_APQUOT_gift_APQUOT_>Guarantee </p>_APENTER__APTAB__APTAB__APTAB__APTAB__APTAB__APENTER__APTAB__APTAB__APTAB__APTAB_</div>_APENTER__APTAB__APTAB__APTAB_</div>_APENTER__APTAB__APTAB_</div>_APENTER__APTAB_</div>_APENTER_</div>"][/ApRawHtml][/ApColumn][ApColumn form_id="form_6017241837790137" lg="6" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApVideo form_id="form_4036245404249706" content_html="<embed width=_APQUOT_570_APQUOT_ height=_APQUOT_308_APQUOT_src=_APQUOT_http://www.youtube.com/v/iZoR21juRzs_APQUOT_type=_APQUOT_application/x-shockwave-flash_APQUOT_></embed>" align="center"][/ApVideo][/ApColumn][/ApRow]\'),
(36, ID_LANG, \'[ApRow form_id="form_20909133825356952" class="row" specific_type="" controller_pages="" controller_id=""][ApColumn form_id="form_9014881273442776" lg="12" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApFullSlider form_id="form_9240818526098300" class="container" width="100%" height="600px" interval="2000" display_title="1" display_indicators="1" is_open="0" total_slider="2|1" img_2_1="slide-home-2.jpg" descript_2_1="<h3>slide show full screen</h3>_APENTER_<p>Discover the collection</p>" img_2_2="slide-home-2.jpg" descript_2_2="<h3>slide show full screen</h3>_APENTER_<p>Discover the collection</p>" img_1_1="slide-home-2.jpg" descript_1_1="<h3>slide show full screen</h3>_APENTER_<p>Discover the collection</p>" img_1_2="slide-home-2.jpg" descript_1_2="<h3>slide show full screen</h3>_APENTER_<p>Discover the collection</p>"][/ApFullSlider][/ApColumn][/ApRow][ApRow form_id="form_5043314318992687" class="row" specific_type="" controller_pages="" controller_id=""][ApColumn form_id="form_5925556932005538" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_10071349966377025" animation="none" animation_delay="0.5" is_open="0" width="100%" height="auto" image="banner-home-1.jpg"][/ApImage][/ApColumn][ApColumn form_id="form_8877774941638354" lg="8" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_21872978641834768" animation="none" animation_delay="0.5" is_open="0" width="100%" height="auto" image="banner-home-2.jpg"][/ApImage][/ApColumn][/ApRow][ApRow form_id="form_5304663603621651" container="producttabs" class="row" bg_position="top" bg_repeat="no-repeat" bg_type="static" parallax_speed="0.1" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id=""][ApColumn form_id="form_5571292122492686" lg="12" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApTabs form_id="form_9176869746551560" class="" tab_type="tabs-top" active_tab="1" fade_effect="0" override_folder="" title=""][ApTab form_id="form_7953498259350545" id="tab_5316272182644061" css_class=" " override_folder="" title="New product"][ApProductCarousel form_id="form_978758423880398" value_by_product_type="1" category_type="all" product_type="new_product" order_way="asc" order_by="position" nb_products="10" carousel_type="owlcarousel" items="4" itemsdesktop="4" itemsdesktopsmall="3" itemstablet="2" itemsmobile="1" itempercolumn="1" autoplay="0" slidespeed="200" stoponhover="0" responsive="1" navigation="0" scrollperpage="0" autoheight="0" mousedrag="1" touchdrag="1" lazyload="false" lazyfollow="0" lazyeffect="fade" pagination="false" paginationnumbers="0" paginationspeed="800" nbitemsperpage="12" nbitemsperline="4" nbitemsperlinetablet="3" nbitemsperlinemobile="2" interval="5000" profile="plist1427203522"][/ApProductCarousel][/ApTab][ApTab form_id="form_9616938961570878" id="tab_2565326581497393" css_class=" " override_folder="" title="Speacial"][ApProductCarousel form_id="form_8681995943495768" value_by_product_type="1" category_type="all" product_type="best_sellers" order_way="asc" order_by="position" nb_products="10" carousel_type="owlcarousel" items="4" itemsdesktop="4" itemsdesktopsmall="3" itemstablet="2" itemsmobile="1" itempercolumn="1" autoplay="0" slidespeed="200" stoponhover="0" responsive="1" navigation="0" scrollperpage="0" autoheight="0" mousedrag="1" touchdrag="1" lazyload="false" lazyfollow="0" lazyeffect="fade" pagination="false" paginationnumbers="0" paginationspeed="800" nbitemsperpage="12" nbitemsperline="4" nbitemsperlinetablet="3" nbitemsperlinemobile="2" interval="5000" profile="plist1427203522"][/ApProductCarousel][/ApTab][ApTab form_id="form_8493713003851098" id="tab_3246911645441533" css_class=" " override_folder="" title="Best seller"][ApProductCarousel form_id="form_30402577402229545" value_by_product_type="1" category_type="all" product_type="best_sellers" order_way="asc" order_by="position" nb_products="10" carousel_type="owlcarousel" items="4" itemsdesktop="4" itemsdesktopsmall="3" itemstablet="2" itemsmobile="1" itempercolumn="1" autoplay="0" slidespeed="200" stoponhover="0" responsive="1" navigation="0" scrollperpage="0" autoheight="0" mousedrag="1" touchdrag="1" lazyload="false" lazyfollow="0" lazyeffect="fade" pagination="false" paginationnumbers="0" paginationspeed="800" nbitemsperpage="12" nbitemsperline="4" nbitemsperlinetablet="3" nbitemsperlinemobile="2" interval="5000" profile="plist1427203522"][/ApProductCarousel][/ApTab][/ApTabs][/ApColumn][/ApRow][ApRow form_id="form_6249219102508735" class="row" specific_type="" controller_pages="" controller_id=""][ApColumn form_id="form_5568517723152148" lg="12" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApRawHtml form_id="form_4308185326658524" content_html="<div class=_APQUOT_custom_home_2_APQUOT_>_APENTER_    <div class=_APQUOT_row_APQUOT_>_APENTER_        <div class=_APQUOT_col-lg-3 col-sm-6 col-xs-12 column_APQUOT_>_APENTER_            <div class=_APQUOT_icon_custom_APQUOT_><span class=_APQUOT_icon-name icon-mobile-phone_APQUOT_> </span>_APENTER__APTAB__APTAB__APTAB__APTAB_<div class=_APQUOT_title_custom_APQUOT_>MOBILE FRIENDLY</div>_APENTER_                <div class=_APQUOT_description_APQUOT_>_APENTER_                    <p>AP Page Builder theme is a modern, clean and professional Prestashop theme, it comes with a lot of useful features.</p>_APENTER_                </div>_APENTER_            </div>_APENTER_        </div>_APENTER_        <div class=_APQUOT_col-lg-3 col-sm-6 col-xs-12 column_APQUOT_>_APENTER_            <div class=_APQUOT_icon_custom_APQUOT_><span class=_APQUOT_icon-name icon-html5_APQUOT_> </span>_APENTER__APTAB__APTAB__APTAB_<div class=_APQUOT_title_custom_APQUOT_>HTML 5 Model</div>_APENTER_                <div class=_APQUOT_description_APQUOT_>_APENTER_                    <p>AP Page Builder theme is a modern, clean and professional Prestashop theme, it comes with a lot of useful features.</p>_APENTER_                </div>_APENTER_            </div>_APENTER_        </div>_APENTER__APTAB__APTAB_<div class=_APQUOT_col-lg-3 col-sm-6 col-xs-12 column_APQUOT_>_APENTER_            <div class=_APQUOT_icon_custom_APQUOT_><span class=_APQUOT_icon-name icon-heart-empty_APQUOT_> </span>_APENTER__APTAB__APTAB__APTAB__APTAB_<div class=_APQUOT_title_custom_APQUOT_>UNLIMITED COLORS</div>_APENTER_                <div class=_APQUOT_description_APQUOT_>_APENTER_                    <p>AP Page Builder theme is a modern, clean and professional Prestashop theme, it comes with a lot of useful features.</p>_APENTER_                </div>_APENTER_            </div>_APENTER_        </div>_APENTER_        <div class=_APQUOT_col-lg-3 col-sm-6 col-xs-12 column_APQUOT_>_APENTER_            <div class=_APQUOT_icon_custom_APQUOT_><span class=_APQUOT_icon-name icon-magic_APQUOT_> </span>_APENTER__APTAB__APTAB__APTAB_<div class=_APQUOT_title_custom_APQUOT_>RETINA READY</div>_APENTER_                <div class=_APQUOT_description_APQUOT_>_APENTER_                    <p>AP Page Builder theme is a modern, clean and professional Prestashop theme, it comes with a lot of useful features.</p>_APENTER_                </div>_APENTER_            </div>_APENTER_        </div>_APENTER_    </div>_APENTER_</div>"][/ApRawHtml][/ApColumn][/ApRow][ApRow form_id="form_5323906977731813" class="row" specific_type="" controller_pages="" controller_id=""][ApColumn form_id="form_12099259711895658" lg="6" md="12" sm="12" xs="12" sp="12" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id="" title="about company"][ApImage form_id="form_2696009325712883" animation="none" animation_delay="0.5" is_open="0" width="100%" height="auto" image="about.jpg" description="<p style=_APQUOT_padding-top: 30px;_APQUOT_>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut Learn More. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua</p>"][/ApImage][/ApColumn][ApColumn form_id="form_8942299050079442" class="accodion_home_1" lg="6" md="12" sm="12" xs="12" sp="12" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id="" title="our service"][ApAccordions form_id="form_30142113790918815" accordion_type="vertical" active_type="hideall" active_accordion="1" id="accordion_9511232060163612"][ApAccordion form_id="form_3929111502699251" parent_id="accordion_9511232060163612" id="collapse_7291172304290975" title="Accordion 1"][ApHtml form_id="form_9503489464176024" content_html="<div>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut Learn More. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</div>"][/ApHtml][/ApAccordion][ApAccordion form_id="form_2432444010961499" parent_id="accordion_9511232060163612" id="collapse_6856873160328414" title="Accordion 2"][ApHtml form_id="form_37137745662024365" content_html="<div>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut Learn More. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</div>"][/ApHtml][/ApAccordion][ApAccordion form_id="form_5974446206019537" parent_id="accordion_9511232060163612" id="collapse-6742230974269376" title="New Accordion"][ApHtml form_id="form_3644694124023897" content_html="<div>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut Learn More. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</div>"][/ApHtml][/ApAccordion][/ApAccordions][/ApColumn][/ApRow][ApRow form_id="form_6997302343881344" class="row" specific_type="" controller_pages="" controller_id=""][ApColumn form_id="form_17890945246255612" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_9158158244994580" animation="none" animation_delay="0.5" is_open="0" width="100%" height="auto" image="banner_1.jpg"][/ApImage][/ApColumn][ApColumn form_id="form_8599989597522363" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_8868434264767529" animation="none" animation_delay="0.5" is_open="0" width="100%" height="auto" image="banner_2.jpg"][/ApImage][/ApColumn][ApColumn form_id="form_20621363858938018" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_3398395372547226" animation="none" animation_delay="0.5" is_open="0" width="100%" height="auto" image="banner_3.jpg"][/ApImage][/ApColumn][/ApRow][ApRow form_id="form_4002002639267890" class="row content_bottom_home2" bg_position="top" bg_repeat="no-repeat" bg_type="static" parallax_speed="0.1" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id=""][ApColumn form_id="form_31559345088155415" lg="6" md="12" sm="12" xs="12" sp="12" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id="" title="from of blog"][ApBlog form_id="form_8861849832048421" chk_cat="3,4,5" bleoblogs_show="0" show_title="1" show_desc="1" bleoblogs_sima="1" bleoblogs_saut="0" bleoblogs_scat="0" bleoblogs_scre="1" bleoblogs_scoun="0" bleoblogs_shits="0" order_way="asc" order_by="id_leoblogcat" nb_blogs="10" carousel_type="boostrap" items="1" itemsdesktop="1" itemsdesktopsmall="1" itemstablet="1" itemsmobile="1" itempercolumn="1" autoplay="0" slidespeed="200" stoponhover="0" responsive="1" navigation="0" scrollperpage="0" autoheight="0" mousedrag="1" touchdrag="1" lazyload="false" lazyfollow="0" lazyeffect="fade" pagination="false" paginationnumbers="0" paginationspeed="800" nbitemsperpage="1" nbitemsperline="1" nbitemsperlinetablet="1" nbitemsperlinemobile="1" interval="5000"][/ApBlog][/ApColumn][ApColumn form_id="form_10209833212367358" lg="6" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApModule form_id="form_20445222394711448" name_module="blocknewsletter" hook="displayLeftColumn" is_display="1"][/ApModule][/ApColumn][/ApRow][ApRow form_id="form_5014581533357989" class="row" specific_type="" controller_pages="" controller_id=""][ApColumn form_id="form_9021709644910436" lg="12" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApVideo form_id="form_8385263303942444" content_html="<embed width=_APQUOT_1170_APQUOT_ height=_APQUOT_500_APQUOT_src=_APQUOT_http://www.youtube.com/v/iZoR21juRzs_APQUOT_type=_APQUOT_application/x-shockwave-flash_APQUOT_></embed>" align="center"][/ApVideo][/ApColumn][/ApRow][ApRow form_id="form_6677122276569918" class="row" specific_type="" controller_pages="" controller_id=""][ApColumn form_id="form_4641512995157973" class="block_carousel_2" lg="6" md="12" sm="12" xs="12" sp="12" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id="" title="client say"][ApBlockCarousel form_id="form_8844382208216726" is_open="0" carousel_type="owlcarousel" items="1" itemsdesktop="1" itemsdesktopsmall="1" itemstablet="1" itemsmobile="1" itempercolumn="1" autoplay="0" slidespeed="200" stoponhover="0" responsive="1" navigation="0" scrollperpage="1" autoheight="0" mousedrag="1" touchdrag="1" lazyload="false" lazyfollow="0" lazyeffect="fade" pagination="false" paginationnumbers="0" paginationspeed="800" nbitemsperpage="1" nbitemsperline="1" nbitemsperlinetablet="1" nbitemsperlinemobile="1" interval="5000" total_slider="2|1" img_2_1="9.png" descript_2_1="<div class=_APQUOT_content-slider_APQUOT_>_APENTER_    <p>Duis sed odio sit amet nibh vutate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio.....</p>_APENTER_    <div class=_APQUOT_testimonial-item _APQUOT_>_APENTER_        <div class=_APQUOT_content_name_APQUOT_>_APENTER_            <h5>JAMES BOYD</h5>_APENTER_            <p>Creative Manager</p>_APENTER_        </div>_APENTER_    </div>_APENTER_</div>" img_2_2="/prestashop/appagebuilder/themes/default-bootstrap/img/modules/appagebuilder/images/9.png" descript_2_2="<div class=_APQUOT_content-slider_APQUOT_>_APENTER_    <p>Duis sed odio sit amet nibh vutate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio.....</p>_APENTER_    <div class=_APQUOT_testimonial-item _APQUOT_>_APENTER_        <div class=_APQUOT_content_name_APQUOT_>_APENTER_            <h5>JAMES BOYD</h5>_APENTER_            <p>Creative Manager</p>_APENTER_        </div>_APENTER_    </div>_APENTER_</div>" img_1_1="10.png" descript_1_1="<div class=_APQUOT_content-slider_APQUOT_>_APENTER_    <p>Duis sed odio sit amet nibh vutate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio.....</p>_APENTER_    <div class=_APQUOT_testimonial-item _APQUOT_>_APENTER_        <div class=_APQUOT_content_name_APQUOT_>_APENTER_            <h5>JAMES BOYD</h5>_APENTER_            <p>Creative Manager</p>_APENTER_        </div>_APENTER_    </div>_APENTER_</div>" img_1_2="/prestashop/appagebuilder/themes/default-bootstrap/img/modules/appagebuilder/images/10.png" descript_1_2="<div class=_APQUOT_content-slider col-md-6 col-sm-6_APQUOT_>_APENTER_    <p>Duis sed odio sit amet nibh vutate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio.....</p>_APENTER_    <div class=_APQUOT_testimonial-item _APQUOT_>_APENTER_        <div class=_APQUOT_content_name_APQUOT_>_APENTER_            <h5>JAMES BOYD</h5>_APENTER_            <p>Creative Manager</p>_APENTER_        </div>_APENTER_    </div>_APENTER_</div>"][/ApBlockCarousel][/ApColumn][ApColumn form_id="form_2903157942744452" class="brand_2" lg="6" md="12" sm="12" xs="12" sp="12" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id="" title="our brand"][ApManuFacturersCarousel form_id="form_27213829832858065" class="" value_by_manufacture="0" manuselect="1,2,3,4,5,6,7" imagetype="medium_default" order_way="asc" order_by="position" manu_limit="10" carousel_type="owlcarousel" items="3" itemsdesktop="3" itemsdesktopsmall="3" itemstablet="2" itemsmobile="1" itemscustom="" itempercolumn="1" autoplay="0" slidespeed="200" stoponhover="0" responsive="1" navigation="0" scrollperpage="0" autoheight="0" mousedrag="1" touchdrag="1" lazyload="false" lazyfollow="0" lazyeffect="fade" pagination="false" paginationnumbers="0" paginationspeed="800" nbitemsperpage="3" nbitemsperline="3" nbitemsperlinetablet="3" nbitemsperlinemobile="2" interval="5000" override_folder="" title=""][/ApManuFacturersCarousel][/ApColumn][/ApRow]\');';
            $sqlArray[] = 'INSERT INTO `'._DB_PREFIX_.'appagebuilder_lang` (`id_appagebuilder`, `id_lang`, `params`) VALUES
(44, ID_LANG, \'[ApRow form_id="form_33446508537010125" id="" container="container slideshow3" class="row" min_height="" margin_top="" margin_bottom="" padding_top="" padding_bottom="" bg_config="boxed" bg_type="normal" bg_color="" bg_img="" bg_position="top" bg_repeat="no-repeat" parallax_speed="0.1" parallax_axis="both" parallax_strength="0.5" parallax_rid="0.5" parallax_hoffsets="0.1" parallax_voffsets="0.1" video_link="" video_id="" animation="none" animation_delay="2" specific_type="all" controller_id="" controller_pages="" title=""][ApColumn form_id="form_19178898242098115" lg="9" md="12" sm="12" xs="12" sp="12" animation="none" animation_delay="2" specific_type="all"][ApSlideShow form_id="form_5895164089177756" slideshow_group="3"][/ApSlideShow][/ApColumn][ApColumn form_id="form_2664131687121597" lg="3" md="12" sm="12" xs="12" sp="12"][ApImage form_id="form_6034295786051325" animation="none" animation_delay="0.5" alt="" css_class="banner-home-3" url="" is_open="0" width="100%" height="auto" override_folder="" title="" image="banner-home3.jpg" description=""][/ApImage][ApImage form_id="form_6195010427776959" animation="none" animation_delay="0.5" is_open="0" width="100%" height="auto" image="banner-home3-1.jpg"][/ApImage][/ApColumn][/ApRow]\'),
(46, ID_LANG, \'[ApRow form_id="form_7828002175780933" container="producttabs container" class="row" bg_position="top" bg_repeat="no-repeat" bg_type="static" parallax_speed="0.1" animation="none" animation_delay="2" specific_type="all"][ApColumn form_id="form_5482717988915945" lg="12" md="12" sm="12" xs="12" sp="12"][ApTabs form_id="form_30921796885283755" tab_type="tabs-top" active_tab="1" fade_effect="0"][ApTab form_id="form_4997013409283097" id="tab_11011953066066252" css_class=" " override_folder="" title="Feature"][ApProductCarousel form_id="form_1614479170838713" value_by_product_type="1" category_type="all" product_type="new_product" order_way="asc" order_by="position" nb_products="10" carousel_type="owlcarousel" items="4" itemsdesktop="4" itemsdesktopsmall="3" itemstablet="2" itemsmobile="1" itempercolumn="1" autoplay="0" slidespeed="200" stoponhover="0" responsive="1" navigation="0" scrollperpage="0" autoheight="0" mousedrag="1" touchdrag="1" lazyload="false" lazyfollow="0" lazyeffect="fade" pagination="false" paginationnumbers="0" paginationspeed="800" nbitemsperpage="12" nbitemsperline="4" nbitemsperlinetablet="3" nbitemsperlinemobile="2" interval="5000" profile="plist1427203522"][/ApProductCarousel][/ApTab][ApTab form_id="form_9254478360678748" id="tab_25829883406056105" css_class=" " override_folder="" title="New arrival"][ApProductCarousel form_id="form_5908876675868156" value_by_product_type="1" category_type="all" product_type="price_drop" order_way="asc" order_by="position" nb_products="10" carousel_type="owlcarousel" items="4" itemsdesktop="4" itemsdesktopsmall="2" itemstablet="2" itemsmobile="1" itempercolumn="1" autoplay="0" slidespeed="200" stoponhover="0" responsive="1" navigation="0" scrollperpage="0" autoheight="0" mousedrag="1" touchdrag="1" lazyload="false" lazyfollow="0" lazyeffect="fade" pagination="false" paginationnumbers="0" paginationspeed="800" nbitemsperpage="12" nbitemsperline="4" nbitemsperlinetablet="3" nbitemsperlinemobile="2" interval="5000" profile="plist1427203522"][/ApProductCarousel][/ApTab][/ApTabs][/ApColumn][/ApRow][ApRow form_id="form_4436122627649137" class="row" bg_position="top" bg_repeat="no-repeat" bg_type="static" parallax_speed="0.1" animation="none" animation_delay="2" specific_type="all"][ApColumn form_id="form_17792867031029825" lg="6" md="12" sm="12" xs="12" sp="12" animation="none" animation_delay="2" specific_type="all" title="about company"][ApRawHtml form_id="form_15298546003707772" content_html="<div class=_APQUOT_html-about_APQUOT_><a href=_APQUOT_#_APQUOT_> <img class=_APQUOT_img-responsive_APQUOT_ src=_APQUOT_/prestashop/appagebuilder/themes/default-bootstrap/img/modules/appagebuilder/about.jpg_APQUOT_ alt=_APQUOT__APQUOT_ /></a><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut Learn More. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p></div>"][/ApRawHtml][/ApColumn][ApColumn form_id="form_9331328023892898" class="accodion_home_1" lg="6" md="12" sm="12" xs="12" sp="12" animation="none" animation_delay="2" specific_type="all" title="our service"][ApAccordions form_id="form_30210881998472865" accordion_type="vertical" active_type="hideall" active_accordion="1" id="accordion_4964980303001500"][ApAccordion form_id="form_3973828613915391" parent_id="accordion_4964980303001500" id="collapse_3305034203612155" title="Accordion 1"][ApHtml form_id="form_5880087725078615" content_html="<div>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut Learn More. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</div>"][/ApHtml][/ApAccordion][ApAccordion form_id="form_8642544296261765" parent_id="accordion_4964980303001500" id="collapse_18499002039142922" title="Accordion 2"][ApHtml form_id="form_6840676983555600" content_html="<div>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut Learn More. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</div>"][/ApHtml][/ApAccordion][ApAccordion form_id="form_28596983889302915" parent_id="accordion_4964980303001500" id="collapse-29889080293661645" title="New Accordion"][ApHtml form_id="form_15144027739111562" content_html="<div>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut Learn More. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</div>"][/ApHtml][/ApAccordion][/ApAccordions][/ApColumn][/ApRow][ApRow form_id="form_12133165511409705" class="row" bg_position="top" bg_repeat="no-repeat" bg_type="static" parallax_speed="0.1" animation="none" animation_delay="2" specific_type="all"][ApColumn form_id="form_5583260119278884" lg="4" md="12" sm="12" xs="12" sp="12"][ApImage form_id="form_3501413145758641" animation="none" animation_delay="0.5" alt="" css_class="" url="" is_open="0" width="100%" height="auto" override_folder="" title="" image="banner_1.jpg" description=""][/ApImage][/ApColumn][ApColumn form_id="form_5074664556280572" lg="4" md="12" sm="12" xs="12" sp="12"][ApImage form_id="form_3297747043173599" animation="none" animation_delay="0.5" alt="" css_class="" url="" is_open="0" width="100%" height="auto" override_folder="" title="" image="banner_2.jpg" description=""][/ApImage][/ApColumn][ApColumn form_id="form_38763375713965105" lg="4" md="12" sm="12" xs="12" sp="12"][ApImage form_id="form_7513267393454680" animation="none" animation_delay="0.5" alt="" css_class="" url="" is_open="0" width="100%" height="auto" override_folder="" title="" image="banner_3.jpg" description=""][/ApImage][/ApColumn][/ApRow][ApRow form_id="form_2640250499663066" id="" container="" class="row blog_home3" min_height="" margin_top="" margin_bottom="" padding_top="" padding_bottom="" bg_config="boxed" bg_type="normal" bg_color="" bg_img="" bg_position="" bg_repeat="no-repeat" parallax_speed="0.1" parallax_axis="both" parallax_strength="0.5" parallax_rid="0.5" parallax_hoffsets="0.1" parallax_voffsets="0.1" video_link="" video_id="" animation="none" animation_delay="2" specific_type="all" controller_id="" controller_pages="" title=""][ApColumn form_id="form_7402532974087180" lg="12" md="12" sm="12" xs="12" sp="12" animation="none" animation_delay="2" specific_type="all" title="from of blog"][ApBlog form_id="form_23494318155898705" chk_cat="3,4,5" bleoblogs_show="0" show_title="1" show_desc="1" bleoblogs_sima="1" bleoblogs_saut="0" bleoblogs_scat="0" bleoblogs_scre="0" bleoblogs_scoun="0" bleoblogs_shits="0" order_way="asc" order_by="id_leoblogcat" nb_blogs="10" carousel_type="owlcarousel" items="2" itemsdesktop="2" itemsdesktopsmall="2" itemstablet="2" itemsmobile="1" itempercolumn="1" autoplay="0" slidespeed="200" stoponhover="0" responsive="1" navigation="0" scrollperpage="0" autoheight="0" mousedrag="1" touchdrag="1" lazyload="false" lazyfollow="0" lazyeffect="fade" pagination="false" paginationnumbers="0" paginationspeed="800" nbitemsperpage="12" nbitemsperline="4" nbitemsperlinetablet="3" nbitemsperlinemobile="2" interval="5000"][/ApBlog][/ApColumn][/ApRow][ApRow form_id="form_8876628956708702" class="row"][ApColumn form_id="form_7274756757028045" lg="12" md="12" sm="12" xs="12" sp="12"][ApVideo form_id="form_5985917453557522" content_html="<embed width=_APQUOT_1170_APQUOT_ height=_APQUOT_500_APQUOT_src=_APQUOT_http://www.youtube.com/v/iZoR21juRzs_APQUOT_type=_APQUOT_application/x-shockwave-flash_APQUOT_></embed>" align="center"][/ApVideo][/ApColumn][/ApRow][ApRow form_id="form_27414955241572425" class="row"][ApColumn form_id="form_18215721913317392" class="fullslide2" lg="6" md="12" sm="12" xs="12" sp="12" animation="none" animation_delay="2" specific_type="all" title="client say"][ApBlockCarousel form_id="form_24397564457652955" is_open="0" carousel_type="boostrap" items="5" itemsdesktop="4" itemsdesktopsmall="3" itemstablet="2" itemsmobile="1" itempercolumn="1" autoplay="0" slidespeed="200" stoponhover="0" responsive="1" navigation="0" scrollperpage="1" autoheight="0" mousedrag="1" touchdrag="1" lazyload="false" lazyfollow="0" lazyeffect="fade" pagination="false" paginationnumbers="0" paginationspeed="800" nbitemsperpage="1" nbitemsperline="1" nbitemsperlinetablet="1" nbitemsperlinemobile="1" interval="5000" total_slider="2|1" img_2_1="9.png" descript_2_1="<div class=_APQUOT_content-slider_APQUOT_>_APENTER_    <p>Duis sed odio sit amet nibh vutate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio.....</p>_APENTER_    <div class=_APQUOT_testimonial-item _APQUOT_>_APENTER_        <div class=_APQUOT_content_name_APQUOT_>_APENTER_            <h5>JAMES BOYD</h5>_APENTER_            <p>Creative Manager</p>_APENTER_        </div>_APENTER_    </div>_APENTER_</div>" img_2_2="/prestashop/appagebuilder/themes/default-bootstrap/img/modules/appagebuilder/images/9.png" descript_2_2="<div class=_APQUOT_content-slider_APQUOT_>_APENTER_    <p>Duis sed odio sit amet nibh vutate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio.....</p>_APENTER_    <div class=_APQUOT_testimonial-item _APQUOT_>_APENTER_        <div class=_APQUOT_content_name_APQUOT_>_APENTER_            <h5>JAMES BOYD</h5>_APENTER_            <p>Creative Manager</p>_APENTER_        </div>_APENTER_    </div>_APENTER_</div>" img_1_1="10.png" descript_1_1="<div class=_APQUOT_content-slider_APQUOT_>_APENTER_    <p>Duis sed odio sit amet nibh vutate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio.....</p>_APENTER_    <div class=_APQUOT_testimonial-item _APQUOT_>_APENTER_        <div class=_APQUOT_content_name_APQUOT_>_APENTER_            <h5>JAMES BOYD</h5>_APENTER_            <p>Creative Manager</p>_APENTER_        </div>_APENTER_    </div>_APENTER_</div>" img_1_2="/prestashop/appagebuilder/themes/default-bootstrap/img/modules/appagebuilder/images/10.png" descript_1_2="<div class=_APQUOT_content-slider_APQUOT_>_APENTER_    <p>Duis sed odio sit amet nibh vutate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio.....</p>_APENTER_    <div class=_APQUOT_testimonial-item _APQUOT_>_APENTER_        <div class=_APQUOT_content_name_APQUOT_>_APENTER_            <h5>JAMES BOYD</h5>_APENTER_            <p>Creative Manager</p>_APENTER_        </div>_APENTER_    </div>_APENTER_</div>"][/ApBlockCarousel][/ApColumn][ApColumn form_id="form_6413768206445044" id="" class="brand_2" lg="6" md="12" sm="12" xs="12" sp="12" animation="none" animation_delay="2" specific_type="all" controller_id="" controller_pages="" title="our brand"][ApManuFacturersCarousel form_id="form_8675019706249885" class="" value_by_manufacture="0" manuselect="8,9,10,11,12,13,14" imagetype="Manu_default" order_way="asc" order_by="position" manu_limit="12" carousel_type="owlcarousel" items="3" itemsdesktop="3" itemsdesktopsmall="3" itemstablet="2" itemsmobile="1" itemscustom="" itempercolumn="1" autoplay="0" slidespeed="200" stoponhover="0" responsive="1" navigation="0" scrollperpage="0" autoheight="0" mousedrag="1" touchdrag="1" lazyload="false" lazyfollow="0" lazyeffect="fade" pagination="false" paginationnumbers="0" paginationspeed="800" nbitemsperpage="3" nbitemsperline="3" nbitemsperlinetablet="3" nbitemsperlinemobile="2" interval="5000" override_folder="" title=""][/ApManuFacturersCarousel][/ApColumn][/ApRow][ApRow form_id="form_6967270358455340" class="row"][ApColumn form_id="form_5804926795409033" lg="12" md="12" sm="12" xs="12" sp="12"][ApGmap form_id="form_7671794195649183" zoom="11" width="100%" height="300px" is_display_list="0"][/ApGmap][/ApColumn][/ApRow]\'),
(54, ID_LANG, \'\');';
            $sqlArray[] = 'INSERT INTO `'._DB_PREFIX_.'appagebuilder_lang` (`id_appagebuilder`, `id_lang`, `params`) VALUES
(56, ID_LANG, \'[ApRow form_id="form_26854844611920815" id="" container="" class="row slideshow3" min_height="" margin_top="" margin_bottom="" padding_top="" padding_bottom="" bg_config="boxed" bg_type="normal" bg_color="" bg_img="" bg_position="top" bg_repeat="no-repeat" parallax_speed="0.1" parallax_axis="both" parallax_strength="0.5" parallax_rid="0.5" parallax_hoffsets="0.1" parallax_voffsets="0.1" video_link="" video_id="" animation="none" animation_delay="2" specific_type="all" controller_id="" controller_pages="" title=""][ApColumn form_id="form_9608322676489876" id="" class="" lg="9" md="12" sm="12" xs="12" sp="12" animation="none" animation_delay="2" specific_type="all" controller_id="" controller_pages="" title=""][ApFullSlider form_id="form_6502796066696235" class="container" width="100%" height="447px" interval="2000" display_title="1" display_indicators="1" is_open="0" total_slider="2|1" img_2_1="slide-home-3.jpg" img_2_2="slide-home-3.jpg" img_1_1="slide-home-3.jpg" img_1_2="slide-home-3.jpg" descript_1_2="<h3>slide show full screen</h3>_APENTER_<p>Discover the collection</p>"][/ApFullSlider][/ApColumn][ApColumn form_id="form_2664131687121597" lg="3" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_6034295786051325" animation="none" animation_delay="0.5" css_class="banner-home-3" is_open="0" width="100%" height="auto" image="banner-home3.jpg"][/ApImage][ApImage form_id="form_8444618643287007" animation="none" animation_delay="0.5" css_class="banner-home-3" is_open="0" width="100%" height="auto" image="banner-home3-1.jpg"][/ApImage][/ApColumn][/ApRow][ApRow form_id="form_7828002175780933" container="producttabs container" class="row" bg_position="top" bg_repeat="no-repeat" bg_type="static" parallax_speed="0.1" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id=""][ApColumn form_id="form_5482717988915945" lg="12" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApTabs form_id="form_30921796885283755" tab_type="tabs-top" active_tab="1" fade_effect="0"][ApTab form_id="form_4997013409283097" id="tab_11011953066066252" css_class=" " override_folder="" title="Feature"][ApProductCarousel form_id="form_3924465722267891" value_by_product_type="1" category_type="all" product_type="new_product" order_way="asc" order_by="position" nb_products="10" carousel_type="owlcarousel" items="4" itemsdesktop="4" itemsdesktopsmall="3" itemstablet="2" itemsmobile="1" itempercolumn="1" autoplay="0" slidespeed="200" stoponhover="0" responsive="1" navigation="1" scrollperpage="0" autoheight="0" mousedrag="1" touchdrag="1" lazyload="false" lazyfollow="0" lazyeffect="fade" pagination="false" paginationnumbers="0" paginationspeed="800" nbitemsperpage="12" nbitemsperline="4" nbitemsperlinetablet="3" nbitemsperlinemobile="2" interval="5000" profile="plist1427203522"][/ApProductCarousel][/ApTab][ApTab form_id="form_9254478360678748" id="tab_25829883406056105" css_class=" " override_folder="" title="New arrival"][ApProductCarousel form_id="form_5908876675868156" value_by_product_type="1" category_type="all" product_type="price_drop" order_way="asc" order_by="position" nb_products="10" carousel_type="owlcarousel" items="4" itemsdesktop="4" itemsdesktopsmall="2" itemstablet="2" itemsmobile="1" itempercolumn="1" autoplay="0" slidespeed="200" stoponhover="0" responsive="1" navigation="0" scrollperpage="0" autoheight="0" mousedrag="1" touchdrag="1" lazyload="false" lazyfollow="0" lazyeffect="fade" pagination="false" paginationnumbers="0" paginationspeed="800" nbitemsperpage="12" nbitemsperline="4" nbitemsperlinetablet="3" nbitemsperlinemobile="2" interval="5000" profile="plist1427203522"][/ApProductCarousel][/ApTab][/ApTabs][/ApColumn][/ApRow][ApRow form_id="form_4436122627649137" class="row" bg_position="top" bg_repeat="no-repeat" bg_type="static" parallax_speed="0.1" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id=""][ApColumn form_id="form_17792867031029825" lg="6" md="12" sm="12" xs="12" sp="12" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id="" title="about company"][ApImage form_id="form_6499927026567396" animation="none" animation_delay="0.5" alt="" css_class="" url="" is_open="0" width="100%" height="auto" override_folder="" title="" image="about.jpg" description="<p style=_APQUOT_padding-top: 10px;_APQUOT_>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut Learn More. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua</p>"][/ApImage][/ApColumn][ApColumn form_id="form_9331328023892898" class="accodion_home_1" lg="6" md="12" sm="12" xs="12" sp="12" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id="" title="our service"][ApAccordions form_id="form_30210881998472865" accordion_type="vertical" active_type="hideall" active_accordion="1" id="accordion_4964980303001500"][ApAccordion form_id="form_3973828613915391" parent_id="accordion_4964980303001500" id="collapse_3305034203612155" title="Accordion 1"][ApHtml form_id="form_5880087725078615" content_html="<div>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut Learn More. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</div>"][/ApHtml][/ApAccordion][ApAccordion form_id="form_8642544296261765" parent_id="accordion_4964980303001500" id="collapse_18499002039142922" title="Accordion 2"][ApHtml form_id="form_6840676983555600" content_html="<div>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut Learn More. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</div>"][/ApHtml][/ApAccordion][ApAccordion form_id="form_28596983889302915" parent_id="accordion_4964980303001500" id="collapse-29889080293661645" title="New Accordion"][ApHtml form_id="form_15144027739111562" content_html="<div>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut Learn More. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</div>"][/ApHtml][/ApAccordion][/ApAccordions][/ApColumn][/ApRow][ApRow form_id="form_12133165511409705" class="row" bg_position="top" bg_repeat="no-repeat" bg_type="static" parallax_speed="0.1" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id=""][ApColumn form_id="form_5583260119278884" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_3501413145758641" animation="none" animation_delay="0.5" is_open="0" width="100%" height="auto" image="banner_1.jpg"][/ApImage][/ApColumn][ApColumn form_id="form_5074664556280572" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_3297747043173599" animation="none" animation_delay="0.5" is_open="0" width="100%" height="auto" image="banner_2.jpg"][/ApImage][/ApColumn][ApColumn form_id="form_38763375713965105" lg="4" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApImage form_id="form_7513267393454680" animation="none" animation_delay="0.5" is_open="0" width="100%" height="auto" image="banner_3.jpg"][/ApImage][/ApColumn][/ApRow][ApRow form_id="form_2640250499663066" class="row blog_home3" bg_config="boxed" bg_type="normal" bg_repeat="no-repeat" parallax_speed="0.1" parallax_axis="both" parallax_strength="0.5" parallax_rid="0.5" parallax_hoffsets="0.1" parallax_voffsets="0.1" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id=""][ApColumn form_id="form_7402532974087180" lg="12" md="12" sm="12" xs="12" sp="12" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id="" title="from of blog"][ApBlog form_id="form_44888530590848425" chk_cat="3,4,5" bleoblogs_show="0" show_title="1" show_desc="1" bleoblogs_sima="1" bleoblogs_saut="0" bleoblogs_scat="0" bleoblogs_scre="1" bleoblogs_scoun="0" bleoblogs_shits="0" order_way="asc" order_by="id_leoblogcat" nb_blogs="10" carousel_type="owlcarousel" items="2" itemsdesktop="2" itemsdesktopsmall="2" itemstablet="2" itemsmobile="1" itempercolumn="1" autoplay="0" slidespeed="200" stoponhover="0" responsive="1" navigation="1" scrollperpage="0" autoheight="0" mousedrag="1" touchdrag="1" lazyload="false" lazyfollow="0" lazyeffect="fade" pagination="false" paginationnumbers="0" paginationspeed="800" nbitemsperpage="12" nbitemsperline="4" nbitemsperlinetablet="3" nbitemsperlinemobile="2" interval="5000"][/ApBlog][/ApColumn][/ApRow][ApRow form_id="form_8876628956708702" class="row" specific_type="" controller_pages="" controller_id=""][ApColumn form_id="form_7274756757028045" lg="12" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApVideo form_id="form_5985917453557522" content_html="<embed width=_APQUOT_1170_APQUOT_ height=_APQUOT_500_APQUOT_src=_APQUOT_http://www.youtube.com/v/iZoR21juRzs_APQUOT_type=_APQUOT_application/x-shockwave-flash_APQUOT_></embed>" align="center"][/ApVideo][/ApColumn][/ApRow][ApRow form_id="form_27414955241572425" class="row" specific_type="" controller_pages="" controller_id=""][ApColumn form_id="form_1818426835455738" class="block_carousel_2 " lg="6" md="12" sm="12" xs="12" sp="12" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id="" title="client say"][ApBlockCarousel form_id="form_4974290262574367" is_open="0" carousel_type="owlcarousel" items="1" itemsdesktop="1" itemsdesktopsmall="1" itemstablet="1" itemsmobile="1" itempercolumn="1" autoplay="0" slidespeed="200" stoponhover="0" responsive="1" navigation="1" scrollperpage="1" autoheight="0" mousedrag="1" touchdrag="1" lazyload="false" lazyfollow="0" lazyeffect="fade" pagination="false" paginationnumbers="0" paginationspeed="800" nbitemsperpage="1" nbitemsperline="1" nbitemsperlinetablet="1" nbitemsperlinemobile="1" interval="5000" total_slider="2|1" img_2_1="9.png" descript_2_1="<div class=_APQUOT_content-slider_APQUOT_>_APENTER_    <p>Duis sed odio sit amet nibh vutate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio.....</p>_APENTER_    <div class=_APQUOT_testimonial-item _APQUOT_>_APENTER_        <div class=_APQUOT_content_name_APQUOT_>_APENTER_            <h5>JAMES BOYD</h5>_APENTER_            <p>Creative Manager</p>_APENTER_        </div>_APENTER_    </div>_APENTER_</div>" img_2_2="/prestashop/appagebuilder/themes/default-bootstrap/img/modules/appagebuilder/images/9.png" descript_2_2="<div class=_APQUOT_content-slider_APQUOT_>_APENTER_    <p>Duis sed odio sit amet nibh vutate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio.....</p>_APENTER_    <div class=_APQUOT_testimonial-item _APQUOT_>_APENTER_        <div class=_APQUOT_content_name_APQUOT_>_APENTER_            <h5>JAMES BOYD</h5>_APENTER_            <p>Creative Manager</p>_APENTER_        </div>_APENTER_    </div>_APENTER_</div>" img_1_1="10.png" descript_1_1="<div class=_APQUOT_content-slider_APQUOT_>_APENTER_    <p>Duis sed odio sit amet nibh vutate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio.....</p>_APENTER_    <div class=_APQUOT_testimonial-item _APQUOT_>_APENTER_        <div class=_APQUOT_content_name_APQUOT_>_APENTER_            <h5>JAMES BOYD</h5>_APENTER_            <p>Creative Manager</p>_APENTER_        </div>_APENTER_    </div>_APENTER_</div>" img_1_2="/prestashop/appagebuilder/themes/default-bootstrap/img/modules/appagebuilder/images/10.png" descript_1_2="<div class=_APQUOT_content-slider_APQUOT_>_APENTER_    <p>Duis sed odio sit amet nibh vutate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio.....</p>_APENTER_    <div class=_APQUOT_testimonial-item _APQUOT_>_APENTER_        <div class=_APQUOT_content_name_APQUOT_>_APENTER_            <h5>JAMES BOYD</h5>_APENTER_            <p>Creative Manager</p>_APENTER_        </div>_APENTER_    </div>_APENTER_</div>"][/ApBlockCarousel][/ApColumn][ApColumn form_id="form_6413768206445044" class="brand_2" lg="6" md="12" sm="12" xs="12" sp="12" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id="" title="our brand"][ApManuFacturersCarousel form_id="form_6674983341547325" value_by_manufacture="0" manuselect="1,2,3,4,5,6,7" imagetype="medium_default" order_way="asc" order_by="position" manu_limit="12" carousel_type="owlcarousel" items="3" itemsdesktop="3" itemsdesktopsmall="3" itemstablet="2" itemsmobile="1" itempercolumn="1" autoplay="0" slidespeed="200" stoponhover="0" responsive="1" navigation="1" scrollperpage="0" autoheight="0" mousedrag="1" touchdrag="1" lazyload="false" lazyfollow="0" lazyeffect="fade" pagination="false" paginationnumbers="0" paginationspeed="800" nbitemsperpage="3" nbitemsperline="3" nbitemsperlinetablet="3" nbitemsperlinemobile="2" interval="5000"][/ApManuFacturersCarousel][/ApColumn][/ApRow][ApRow form_id="form_8044905654991398" class="row" bg_config="fullwidth" bg_type="normal" bg_repeat="no-repeat" parallax_speed="0.1" parallax_axis="both" parallax_strength="0.5" parallax_rid="0.5" parallax_hoffsets="0.1" parallax_voffsets="0.1" animation="none" animation_delay="2" specific_type="all" controller_pages="" controller_id=""][ApColumn form_id="form_5804926795409033" lg="12" md="12" sm="12" xs="12" sp="12" specific_type="" controller_pages="" controller_id=""][ApGmap form_id="form_7671794195649183" zoom="11" width="100%" height="300px" is_display_list="0"][/ApGmap][/ApColumn][/ApRow]\');';
            $languages = Language::getLanguages(false);
            foreach ($sqlArray as $sql) {
                foreach ($languages as $lang) {
                    $sqlRun = str_replace('ID_LANG', $lang["id_lang"], $sql);
                    Db::getInstance()->execute($sqlRun);
                }
            }

            //table appagebuilder_shop
            Db::getInstance()->execute('TRUNCATE TABLE `'._DB_PREFIX_.'appagebuilder_shop`');
            $sql = 'INSERT INTO `'._DB_PREFIX_.'appagebuilder_shop` (`id_appagebuilder`, `id_shop`) VALUES
(1, ID_SHOP),
(2, ID_SHOP),
(3, ID_SHOP),
(4, ID_SHOP),
(5, ID_SHOP),
(6, ID_SHOP),
(7, ID_SHOP),
(8, ID_SHOP),
(9, ID_SHOP),
(10, ID_SHOP),
(11, ID_SHOP),
(12, ID_SHOP),
(13, ID_SHOP),
(14, ID_SHOP),
(15, ID_SHOP),
(16, ID_SHOP),
(17, ID_SHOP),
(18, ID_SHOP),
(19, ID_SHOP),
(20, ID_SHOP),
(21, ID_SHOP),
(22, ID_SHOP),
(23, ID_SHOP),
(24, ID_SHOP),
(25, ID_SHOP),
(26, ID_SHOP),
(27, ID_SHOP),
(28, ID_SHOP),
(29, ID_SHOP),
(30, ID_SHOP),
(31, ID_SHOP),
(32, ID_SHOP),
(33, ID_SHOP),
(34, ID_SHOP),
(35, ID_SHOP),
(36, ID_SHOP),
(37, ID_SHOP),
(38, ID_SHOP),
(39, ID_SHOP),
(40, ID_SHOP),
(41, ID_SHOP),
(42, ID_SHOP),
(43, ID_SHOP),
(44, ID_SHOP),
(45, ID_SHOP),
(46, ID_SHOP),
(47, ID_SHOP),
(48, ID_SHOP),
(49, ID_SHOP),
(50, ID_SHOP),
(51, ID_SHOP),
(52, ID_SHOP),
(53, ID_SHOP),
(54, ID_SHOP),
(55, ID_SHOP),
(56, ID_SHOP),
(57, ID_SHOP),
(58, ID_SHOP),
(59, ID_SHOP),
(60, ID_SHOP),
(61, ID_SHOP),
(62, ID_SHOP),
(63, ID_SHOP),
(64, ID_SHOP),
(65, ID_SHOP);';
            $sql = str_replace('ID_SHOP', $id_shop, $sql);
            Db::getInstance()->execute($sql);

            //table appagebuilder_products
            Db::getInstance()->execute('TRUNCATE TABLE `'._DB_PREFIX_.'appagebuilder_products`');
            $sql = 'INSERT INTO `'._DB_PREFIX_.'appagebuilder_products` (`id_appagebuilder_products`, `plist_key`, `name`, `params`, `type`, `class`, `active`) VALUES
(1, \'plist1427203522\', \'plist1427203522\', \'{"gridLeft":{"0":{"name":"image_container"},"1":{"name":"quick_view"}},"gridRight":{"0":{"name":"price"},"1":{"name":"reviews"},"2":{"name":"name"},"3":{"name":"functional_buttons","element":{"0":{"name":"wishlist"},"1":{"name":"add_to_cart"},"2":{"name":"compare"}}}}}\', 0, \'\', NULL);';
            Db::getInstance()->execute($sql);

            //table appagebuilder_products_shop
            Db::getInstance()->execute('TRUNCATE TABLE `'._DB_PREFIX_.'appagebuilder_products_shop`');
            $sql = 'INSERT INTO `'._DB_PREFIX_.'appagebuilder_products_shop` (`id_appagebuilder_products`, `id_shop`, `active`) VALUES
(1, ID_SHOP, 1)';
            $sql = str_replace('ID_SHOP', $id_shop, $sql);
            Db::getInstance()->execute($sql);

            //copy product profile
            $folder = _PS_ROOT_DIR_.'/themes/'._THEME_NAME_.'/profiles/';
            if (!is_dir($folder)) {
                mkdir($folder, 0755, true);
            }
            $tpl_grid = Tools::file_get_contents(_PS_MODULE_DIR_.'appagebuilder/views/templates/front/product-item/plist1427203522.tpl');
            ApPageSetting::writeFile($folder, 'plist1427203522.tpl', $tpl_grid);
        }

        public static function installModuleTab()
        {
            $id_parent = Tab::getIdFromClassName('IMPROVE');

            //create parent tab
            $newtab = new Tab();
            $newtab->class_name = 'AdminApPageBuilder';
            $newtab->id_parent = $id_parent;
            $newtab->module = 'appagebuilder';
            foreach (Language::getLanguages() as $l) {
                $newtab->name[$l['id_lang']] = Context::getContext()->getTranslator()->trans('Ap PageBuilder', array(), 'Modules.Appagebuilder.Admin');
            }

            if ($newtab->save()) {

                $id_parent = $newtab->id;
                # insert icon for tab
                Db::getInstance()->execute(' UPDATE `'._DB_PREFIX_.'tab` SET `icon` = "tab" WHERE `id_tab` = "'.(int)$newtab->id.'"');

                foreach (self::getTabs() as $tab) {
                    $newtab = new Tab();
                    $newtab->class_name = $tab['class_name'];
                    $newtab->id_parent = isset($tab['id_parent']) ? $tab['id_parent'] : $id_parent;
                    $newtab->module = 'appagebuilder';
                    foreach (Language::getLanguages() as $l) {
                        $newtab->name[$l['id_lang']] = Context::getContext()->getTranslator()->trans($tab['name'], array(), 'Modules.Appagebuilder.Admin');
                    }
                    $newtab->save();
                }
                return true;
            }
            
            return false;
        }

        public static function installConfiguration()
        {
            $res = true;
            $res &= Configuration::updateValue('APPAGEBUILDER_PRODUCT_MAX_RANDOM', 2);
            $res &= Configuration::updateValue('APPAGEBUILDER_GUIDE', 1);
            $res &= Configuration::updateValue('APPAGEBUILDER_LOAD_OWL', 1);
            $res &= Configuration::updateValue('APPAGEBUILDER_LOAD_STELLAR', 1);
            $res &= Configuration::updateValue('APPAGEBUILDER_LOAD_WAYPOINTS', 1);
            $res &= Configuration::updateValue('APPAGEBUILDER_LOAD_INSTAFEED', 0);
            $res &= Configuration::updateValue('APPAGEBUILDER_LOAD_HTML5VIDEO', 0);
            $res &= Configuration::updateValue('APPAGEBUILDER_SAVE_MULTITHREARING', 1);
            $res &= Configuration::updateValue('APPAGEBUILDER_LOAD_FULLPAGEJS', 0);
            $res &= Configuration::updateValue('APPAGEBUILDER_LOAD_IMAGE360', 0);
            $res &= Configuration::updateValue('APPAGEBUILDER_LOAD_IMAGEHOTPOT', 0);
            $res &= Configuration::updateValue('APPAGEBUILDER_SAVE_SUBMIT', 1);
//            $res &= Configuration::updateValue('APPAGEBUILDER_LOAD_AJAX', 1);
//            $res &= Configuration::updateValue('APPAGEBUILDER_LOAD_PN', 1);
            $res &= Configuration::updateValue('APPAGEBUILDER_LOAD_TRAN', 1);
            $res &= Configuration::updateValue('APPAGEBUILDER_LOAD_IMG', 0);
            $res &= Configuration::updateValue('APPAGEBUILDER_LOAD_COUNT', 1);
//            $res &= Configuration::updateValue('APPAGEBUILDER_LOAD_COLOR', 1);
//            $res &= Configuration::updateValue('APPAGEBUILDER_LOAD_ACOLOR', 1);
            $res &= Configuration::updateValue('APPAGEBUILDER_COLOR', '');
            $res &= Configuration::updateValue('APPAGEBUILDER_COOKIE_PROFILE', 0);

            $res &= Configuration::updateValue('APPAGEBUILDER_HEADER_HOOK', implode(',', ApPageSetting::getHook('header')));
            $res &= Configuration::updateValue('APPAGEBUILDER_CONTENT_HOOK', implode(',', ApPageSetting::getHook('content')));
            $res &= Configuration::updateValue('APPAGEBUILDER_FOOTER_HOOK', implode(',', ApPageSetting::getHook('footer')));
            $res &= Configuration::updateValue('APPAGEBUILDER_PRODUCT_HOOK', implode(',', ApPageSetting::getHook('product')));
			
            $res &= Configuration::updateValue('APPAGEBUILDER_GLOBAL_HEADER_ID', 0);
            $res &= Configuration::updateValue('APPAGEBUILDER_GLOBAL_CONTENT_ID', 0);
            $res &= Configuration::updateValue('APPAGEBUILDER_GLOBAL_FOOTER_ID', 0);
            $res &= Configuration::updateValue('APPAGEBUILDER_GLOBAL_PRODUCT_ID', 0);
            $res &= Configuration::updateValue('APPAGEBUILDER_GLOBAL_PROFILE_PARAM', '');
            return $res;
        }

        public static function deleteTables()
        {
            return Db::getInstance()->execute('DROP TABLE IF EXISTS `'.
                _DB_PREFIX_.'appagebuilder_profiles`, `'.
                _DB_PREFIX_.'appagebuilder_profiles_lang`, `'.
                _DB_PREFIX_.'appagebuilder_profiles_shop`, `'.
                _DB_PREFIX_.'appagebuilder_products`, `'.
                _DB_PREFIX_.'appagebuilder_products_shop` , `'.
                _DB_PREFIX_.'appagebuilder`, `'.
                _DB_PREFIX_.'appagebuilder_shop`, `'.
                _DB_PREFIX_.'appagebuilder_lang`, `'.
                _DB_PREFIX_.'appagebuilder_positions`, `'.
                _DB_PREFIX_.'appagebuilder_positions_shop`;
            ');
        }
        
        public static function uninstallModuleTab()
        {
            $id = Tab::getIdFromClassName('AdminApPageBuilder');
            if ($id) {
                $tab = new Tab($id);
                $tab->delete();
            }

            foreach (self::getTabs() as $tab) {
                $id = Tab::getIdFromClassName($tab['class_name']);
                if ($id) {
                    $tab = new Tab($id);
                    $tab->delete();
                }
            }
            return true;
        }
        
        public static function uninstallConfiguration()
        {
            $res = true;
            $res &= Configuration::deleteByName('APPAGEBUILDER_PRODUCT_MAX_RANDOM');
            $res &= Configuration::deleteByName('APPAGEBUILDER_GUIDE');
            $res &= Configuration::deleteByName('APPAGEBUILDER_LOAD_OWL');
            $res &= Configuration::deleteByName('APPAGEBUILDER_LOAD_STELLAR');
            $res &= Configuration::deleteByName('APPAGEBUILDER_LOAD_WAYPOINTS');
            $res &= Configuration::deleteByName('APPAGEBUILDER_LOAD_INSTAFEED');
            $res &= Configuration::deleteByName('APPAGEBUILDER_LOAD_HTML5VIDEO');
            $res &= Configuration::deleteByName('APPAGEBUILDER_SAVE_MULTITHREARING');
            $res &= Configuration::deleteByName('APPAGEBUILDER_LOAD_FULLPAGEJS');
            $res &= Configuration::deleteByName('APPAGEBUILDER_LOAD_IMAGE360');
            $res &= Configuration::deleteByName('APPAGEBUILDER_LOAD_IMAGEHOTPOT');
            $res &= Configuration::deleteByName('APPAGEBUILDER_SAVE_SUBMIT');
//            $res &= Configuration::deleteByName('APPAGEBUILDER_LOAD_AJAX');
//            $res &= Configuration::deleteByName('APPAGEBUILDER_LOAD_PN');
            $res &= Configuration::deleteByName('APPAGEBUILDER_LOAD_TRAN');
            $res &= Configuration::deleteByName('APPAGEBUILDER_LOAD_IMG');
            $res &= Configuration::deleteByName('APPAGEBUILDER_LOAD_COUNT');
//            $res &= Configuration::deleteByName('APPAGEBUILDER_LOAD_COLOR');
//            $res &= Configuration::deleteByName('APPAGEBUILDER_LOAD_ACOLOR');
            $res &= Configuration::deleteByName('APPAGEBUILDER_COLOR');
            $res &= Configuration::deleteByName('APPAGEBUILDER_COOKIE_PROFILE');
            
            
            $res &= Configuration::deleteByName('APPAGEBUILDER_HEADER_HOOK');
            $res &= Configuration::deleteByName('APPAGEBUILDER_CONTENT_HOOK');
            $res &= Configuration::deleteByName('APPAGEBUILDER_FOOTER_HOOK');
            $res &= Configuration::deleteByName('APPAGEBUILDER_PRODUCT_HOOK');

            $res &= Configuration::deleteByName('APPAGEBUILDER_GLOBAL_HEADER_ID');
            $res &= Configuration::deleteByName('APPAGEBUILDER_GLOBAL_CONTENT_ID');
            $res &= Configuration::deleteByName('APPAGEBUILDER_GLOBAL_FOOTER_ID');
            $res &= Configuration::deleteByName('APPAGEBUILDER_GLOBAL_PRODUCT_ID');
            $res &= Configuration::deleteByName('APPAGEBUILDER_GLOBAL_PROFILE_PARAM');
            
            return $res;
        }
        
        /**
         * Remove file index.php in sub folder theme/translations folder when install theme
         */
        public static function processTranslateTheme()
        {
            $theme_name = apPageHelper::getInstallationThemeName();
            if (file_exists(_PS_ALL_THEMES_DIR_.$theme_name.'/config.xml')) {
                $directories = glob(_PS_ALL_THEMES_DIR_.$theme_name.'/translations/*', GLOB_ONLYDIR);	
                if (count($directories) > 0)
                {
                    foreach ($directories as $directories_val)
                    {
                        if (file_exists($directories_val.'/index.php'))
                        {
                            unlink($directories_val.'/index.php');
                        }
                    }
                }
            }
        }
        
        /**
         * Remove file index.php for translate in Quickstart version
         */
        public static function processTranslateQSTheme()
        {
            # GET ARRAY THEME_NAME
            $arr_theme_name = array();
            $themes = glob(_PS_ROOT_DIR_.'/themes/*/config/theme.yml');
            if(count($themes) > 1){
                foreach ($themes as $key => $value) {
                    $temp_name = basename(Tools::substr($value, 0, -strlen('/config/theme.yml')));
                    if($temp_name == 'classic'){
                        continue;
                    }else{
                        $arr_theme_name[] = $temp_name;
                    }
                }
            }
            
            foreach ($arr_theme_name as $key => $theme_name) {
                //DONGND:: remove index.php in sub folder theme/translations folder when install theme
                
                if (file_exists(_PS_ALL_THEMES_DIR_.$theme_name.'/config.xml')) {
                    $directories = glob(_PS_ALL_THEMES_DIR_.$theme_name.'/translations/*', GLOB_ONLYDIR);	
                    if (count($directories) > 0)
                    {
                        foreach ($directories as $directories_val)
                        {
                            if (file_exists($directories_val.'/index.php'))
                            {
                                unlink($directories_val.'/index.php');
                            }
                        }
                    }
                }
            }
        }
    }

}