{*
 * @author: Nexi Payments SpA
 * @copyright: © 2017, Nexi Payments SpA
 * @license: GNU General Public License v3.0
*}
{capture name=path}{l s='Nexi XPay payment.' mod='nexixpay'}{/capture}

<h2>{l s='Order summary' mod='nexixpay'}</h2>


{if $nbProducts <= 0}
    <p class="warning">{l s='Your shopping cart is empty.' mod='nexixpay'}</p>
{else}

    <h3>{$title|escape:'htmlall':'UTF-8'}</h3>
    <form action="{$link->getModuleLink('nexixpay', 'redirect', [], true)|escape:'htmlall':'UTF-8'}" method="post">
        <p>
            <img src="{$this_path_bw|escape:'htmlall':'UTF-8'}/views/img/logo.jpg" alt="{l s='Nexi XPay' mod='nexixpay'}" width="300" height="50" style="margin: 0px 10px 5px 0px;" />
            <br>
            {$description|escape:'htmlall':'UTF-8'} 
            <br/><br />
            {l s='Here is a short summary of your order:' mod='nexixpay'}
        </p>
        <p style="margin-top:20px;">
            - {l s='The total amount of your order is' mod='nexixpay'}
            <span id="amount" class="price">{$total|escape:'htmlall':'UTF-8'}</span>

        </p>
        <p>

        </p>
        <p>
            <br /><br />
            <b>{l s='Please confirm your order by clicking "Place my order"' mod='nexixpay'}.</b>
        </p>
        <p class="cart_navigation">
            <input type="submit" name="submit" value="{l s='Place my order' mod='nexixpay'}" class="exclusive_large" />
            <a href="{$link->getPageLink('order', true, NULL, "step=3")|escape:'htmlall':'UTF-8'}" class="button_large">{l s='Other payment methods' mod='nexixpay'}</a>
        </p>
    </form>
{/if}

