<?php
/**
 * @author: Nexi Payments SpA
 * @copyright: © 2017, Nexi Payments SpA
 * @license: GNU General Public License v3.0
 */

require_once 'include/require.php';

if (!defined('_PS_VERSION_')) {
    exit;
}

class NexiXPay extends PaymentModule
{
    public function __construct()
    {
        $this->name = 'nexixpay';
        $this->tab = 'payments_gateways';
        $this->version = '2.0.0';
        $this->author = 'Nexi Payments SpA';
        $this->ps_versions_compliancy = array('min' => '1.5', 'max' => '1.6');
        $this->dependencies = array();
        $this->currencies = true;
        $this->currencies_mode = 'checkbox';
        $this->module_key = 'cfa2f3eb3553d9f7f2645df7556f9e62';
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('Nexi XPay');
        $this->description = $this->l('Nexi XPay credit/debit card payment gateway.');

        $this->confirmUninstall = $this->l('Are you sure you want to uninstall?');
    }

    public function install()
    {

        Configuration::updateValue('NEXIXPAY_TITLE', $this->l('Payment Cards'));
        Configuration::updateValue('NEXIXPAY_DESCRIPTION', $this->l('Pay securely by credit and debit card or alternative payment methods through Nexi.'));
        Configuration::updateValue('NEXIXPAY_LANGUAGE', 'AUTO');
        Configuration::updateValue('NEXIXPAY_TEST', 0);

        if (!parent::install() || !$this->registerHook('payment') || !$this->registerHook('paymentReturn') || !$this->registerHook('paymentOptions')) {
            return false;
        }

        return true;
    }

    public function uninstall()
    {
        Configuration::deleteByName('NEXIXPAY_TITLE');
        Configuration::deleteByName('NEXIXPAY_DESCRIPTION');
        Configuration::deleteByName('NEXIXPAY_ALIAS');
        Configuration::deleteByName('NEXIXPAY_MAC_KEY');
        Configuration::deleteByName('NEXIXPAY_ALIAS_TEST');
        Configuration::deleteByName('NEXIXPAY_MAC_KEY_TEST');
        Configuration::deleteByName('NEXIXPAY_LANGUAGE');
        Configuration::deleteByName('NEXIXPAY_TEST');

        parent::uninstall();
        return true;
    }

    public function getContent()
    {
        $output = "";

        if (Tools::isSubmit('btnSubmit')) {
            self::updateParam('NEXIXPAY_TITLE');
            self::updateParam('NEXIXPAY_DESCRIPTION');
            self::updateParam('NEXIXPAY_ALIAS');
            self::updateParam('NEXIXPAY_MAC_KEY');
            self::updateParam('NEXIXPAY_ALIAS_TEST');
            self::updateParam('NEXIXPAY_MAC_KEY_TEST');
            self::updateParam('NEXIXPAY_LANGUAGE');
            self::updateParam('NEXIXPAY_TEST');

            $output .= $this->displayConfirmation($this->l('Settings updated'));
        }

        return $output . $this->displayForm();
    }

    private static function updateParam($param)
    {
        Configuration::updateValue($param, Tools::getValue($param));
    }

    private static function validConfigParameter($param)
    {
        $my_module_name = '' + Tools::getValue($param);
        if ($my_module_name == '') {
            return false;
        }

        return true;
    }

    public function displayForm()
    {
        $this->smarty->assign('NEXIXPAY_TITLE', Tools::getValue('NEXIXPAY_TITLE', Configuration::get('NEXIXPAY_TITLE')));
        $this->smarty->assign('NEXIXPAY_DESCRIPTION', Tools::getValue('NEXIXPAY_DESCRIPTION', Configuration::get('NEXIXPAY_DESCRIPTION')));
        $this->smarty->assign('NEXIXPAY_ALIAS', Tools::getValue('NEXIXPAY_ALIAS', Configuration::get('NEXIXPAY_ALIAS')));
        $this->smarty->assign('NEXIXPAY_MAC_KEY', Tools::getValue('NEXIXPAY_MAC_KEY', Configuration::get('NEXIXPAY_MAC_KEY')));
        $this->smarty->assign('NEXIXPAY_ALIAS_TEST', Tools::getValue('NEXIXPAY_ALIAS_TEST', Configuration::get('NEXIXPAY_ALIAS_TEST')));
        $this->smarty->assign('NEXIXPAY_MAC_KEY_TEST', Tools::getValue('NEXIXPAY_MAC_KEY_TEST', Configuration::get('NEXIXPAY_MAC_KEY_TEST')));
        $this->smarty->assign('NEXIXPAY_LANGUAGE', Tools::getValue('NEXIXPAY_LANGUAGE', Configuration::get('NEXIXPAY_LANGUAGE')));
        $this->smarty->assign('NEXIXPAY_TEST', Tools::getValue('NEXIXPAY_TEST', Configuration::get('NEXIXPAY_TEST')));
        
        $this->smarty->assign('ps_version', _PS_VERSION_);
        
        $this->context->controller->addJS('https://cdnjs.cloudflare.com/ajax/libs/riot/2.6.1/riot.min.js');
        $this->context->controller->addJS('https://cdnjs.cloudflare.com/ajax/libs/riot/2.6.1/riot+compiler.min.js');

        $html = $this->display(__FILE__, 'views/templates/admin/configuration.tpl');

        return $html .
                $this->display(__FILE__, 'views/templates/admin/prestui-0.6.0/ps-alert.tpl') .
                $this->display(__FILE__, 'views/templates/admin/prestui-0.6.0/ps-form.tpl') .
                $this->display(__FILE__, 'views/templates/admin/prestui-0.6.0/ps-panel.tpl') .
                $this->display(__FILE__, 'views/templates/admin/prestui-0.6.0/ps-table.tpl') .
                $this->display(__FILE__, 'views/templates/admin/prestui-0.6.0/ps-tabs.tpl') .
                $this->display(__FILE__, 'views/templates/admin/prestui-0.6.0/ps-tags.tpl');
    }

    public function hookPaymentOptions($params)
    {
        if (!$this->active) {
            return;
        }

        if (!$this->checkCurrency($params['cart'])) {
            return;
        }

        $newOption = new PaymentOption();
        $newOption->setCallToActionText(Configuration::get('NEXIXPAY_TITLE'))
                ->setAction($this->context->link->getModuleLink($this->name, 'payment', array(), true))
                ->setAdditionalInformation("<section><img src='" . $this->_path  . "/views/img/logo.jpg'><br><p>" . Configuration::get('NEXIXPAY_DESCRIPTION') . "</p></section>");
        $payment_options = array(
            $newOption
        );

        return $payment_options;
    }

    public function hookPayment($params)
    {
        if (!$this->active) {
            return;
        }
        if (!$this->checkCurrency($params['cart'])) {
            return;
        }

        $this->smarty->assign(array(
            'title' => Configuration::get('NEXIXPAY_TITLE'),
            'description' => Configuration::get('NEXIXPAY_DESCRIPTION'),
            'this_path' => $this->_path,
            'this_path_bw' => $this->_path,
            'this_path_ssl' => Tools::getShopDomainSsl(true, true) . __PS_BASE_URI__ . 'modules/' . $this->name . '/',
        ));

        return $this->display(__FILE__, 'payment.tpl');
    }

    public function hookPaymentReturn($params)
    {
        if (!$this->active) {
            return;
        }

        $state = $params['objOrder']->getCurrentState();
        if (in_array($state, array(Configuration::get('PS_OS_PAYMENT'), Configuration::get('PS_OS_OUTOFSTOCK'), Configuration::get('PS_OS_OUTOFSTOCK_UNPAID')))) {
            $this->smarty->assign(array(
              'total_to_pay' => Tools::displayPrice($params['total_to_pay'], $params['currencyObj'], false),
              'status' => 'ok',
              'id_order' => $params['objOrder']->id,
            ));
            if (isset($params['objOrder']->reference) && !empty($params['objOrder']->reference)) {
                $this->smarty->assign('reference', $params['objOrder']->reference);
            }
        } else {
            $this->smarty->assign('status', 'failed');
        }

        return $this->display(__FILE__, 'payment_return.tpl');
    }

    public function checkCurrency($cart)
    {
        $currency_order = new Currency($cart->id_currency);
        $currencies_module = $this->getCurrency($cart->id_currency);

        //is only allowed EUR as currency
        if ($currency_order->iso_code != "EUR") {
            return false;
        }

        if (is_array($currencies_module)) {
            foreach ($currencies_module as $currency_module) {
                if ($currency_order->id == $currency_module['id_currency']) {
                    return true;
                }
            }
        }

        return false;
    }

    public function getConfiguration()
    {
        $paymentGateway = new NexiXPayParameters();
        if (Configuration::get('NEXIXPAY_TEST')) {
            $paymentGateway->url_pagina_cassa = 'https://int-ecommerce.nexi.it/ecomm/ecomm/DispatcherServlet';
            $paymentGateway->nexi_mac = Configuration::get('NEXIXPAY_MAC_KEY_TEST');
            $paymentGateway->nexi_alias = Configuration::get('NEXIXPAY_ALIAS_TEST');
            $paymentGateway->test_mode = true;
        } else {
            $paymentGateway->url_pagina_cassa = 'https://ecommerce.nexi.it/ecomm/ecomm/DispatcherServlet';
            $paymentGateway->nexi_mac = Configuration::get('NEXIXPAY_MAC_KEY');
            $paymentGateway->nexi_alias = Configuration::get('NEXIXPAY_ALIAS');
            $paymentGateway->test_mode = false;
        }
        
        $paymentGateway->urlpost = urlencode($this->context->link->getModuleLink("nexixpay", "S2S"));
        $paymentGateway->nexi_form_language = Configuration::get('NEXIXPAY_LANGUAGE');
        $paymentGateway->url_back = urlencode($this->context->link->getModuleLink("nexixpay", "annullo"));
        $paymentGateway->url = urlencode($this->context->link->getModuleLink("nexixpay", "ritorno"));

        return $paymentGateway;
    }
}
