<?php
/**
 * @author: Nexi Payments SpA
 * @copyright: © 2017, Nexi Payments SpA
 * @license: GNU General Public License v3.0
 */

class NexiXPayRequest
{

    private $urlRequest;
    private $alias;
    private $importo;
    private $divisa = 'EUR';
    private $codTrans;
    private $url;
    private $urlBack;
    private $macKey;
    private $mac;
    private $mail;
    private $languageId;
    private $urlpost;
    private $descrizione;
    private $sessionId;
    private $Note1 = 'prestashop';
    private $Note2 = '1.6.x';

    private $urlRedirect;

    public function __construct($urlRequest)
    {
        $this->urlRequest = $urlRequest;
    }

    /**
     * @return urlRequest
     */
    public function getUrlRequest()
    {
        return $this->urlRequest;
    }

    /**
     * @param urlRequest
     */
    public function setUrlRequest($urlRequest)
    {
        $this->urlRequest = $urlRequest;
    }

    /**
     * @return alias
     */
    public function getAlias()
    {
        return $this->alias;
    }

    /**
     * @param alias
     */
    public function setAlias($alias)
    {
        $this->alias = $alias;
    }

    /**
     * @return importo
     */
    public function getImporto()
    {
        return $this->importo;
    }

    /**
     * @param importo
     */
    public function setImporto($importo)
    {
        $this->importo = $importo;
    }

    /**
     * @return codTrans
     */
    public function getCodTrans()
    {
        return $this->codTrans;
    }

    /**
     * @param codTrans
     */
    public function setCodTrans($codTrans)
    {
        $this->codTrans = $codTrans;
    }

    /**
     * @return url
     */
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * @param url
     */
    public function setUrl($url)
    {
        $this->url = $url;
    }

    /**
     * @return urlBack
     */
    public function getUrlBack()
    {
        return $this->urlBack;
    }

    /**
     * @param urlBack
     */
    public function setUrlBack($urlBack)
    {
        $this->urlBack = $urlBack;
    }

    /**
     * @return macKey
     */
    public function getMacKey()
    {
        return $this->macKey;
    }

    /**
     * @param macKey
     */
    public function setMacKey($macKey)
    {
        $this->macKey = $macKey;
    }

    /**
     * @return mail
     */
    public function getMail()
    {
        return $this->mail;
    }

    /**
     * @param mail
     */
    public function setMail($mail)
    {
        $this->mail = $mail;
    }

    /**
     * @return languageId
     */
    public function getLanguageId()
    {
        return $this->languageId;
    }

    /**
     * @param languageId
     */
    public function setLanguageId($languageId)
    {
        $this->languageId = $languageId;
    }

    /**
     * @return urlpost
     */
    public function getUrlpost()
    {
        return $this->urlpost;
    }

    /**
     * @param urlpost
     */
    public function setUrlpost($urlpost)
    {
        $this->urlpost = $urlpost;
    }

    /**
     * @return descrizione
     */
    public function getDescrizione()
    {
        return $this->descrizione;
    }

    /**
     * @param descrizione
     */
    public function setDescrizione($descrizione)
    {
        $this->descrizione = $descrizione;
    }

    /**
     * @return sessionId
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }

    /**
     * @param sessionId
     */
    public function setSessionId($sessionId)
    {
        $this->sessionId = $sessionId;
    }

    /**
     * @return parametriAggiuntivi
     */
    public function getParametriAggiuntivi()
    {
        return $this->parametriAggiuntivi;
    }

    /**
     * @param parametriAggiuntivi
     */
    public function setParametriAggiuntivi($parametriAggiuntivi)
    {
        $this->parametriAggiuntivi = $parametriAggiuntivi;
    }

    /**
     * @return mac
     */
    public function getMac()
    {
        return $this->mac;
    }

    /**
     * @param mac
     */
    public function setMac($mac)
    {
        $this->mac = $mac;
    }

    /*
     * public function getFields(){ List<String> fields = new ArrayList<String>();
     * }
     */

    private function macCalcolato()
    {
        return sha1('codTrans=' . $this->codTrans . 'divisa=' . $this->divisa . 'importo=' . $this->importo . $this->macKey);
    }

    /**
     * @return divisa
     */
    public function getDivisa()
    {
        return $this->divisa;
    }

    /**
     * @param divisa
     */
    public function setDivisa($divisa)
    {
        $this->divisa = $divisa;
    }

    public function calculateUrlRedirect()
    {
        $this->urlRedirect = $this->urlRequest;

        $this->urlRedirect .= '?';

        if ($this->alias != null && !empty($this->alias)) {
            $this->urlRedirect .= 'alias=' . $this->alias;
        } else {
            throw new Exception('Alias required');
        }

        if ($this->importo != null) {
            $this->urlRedirect .= '&importo=' . $this->importo;
        } else {
            throw new Exception('importo required');
        }

        if ($this->divisa != null) {
            $this->urlRedirect .= '&divisa=' . $this->divisa;
        } else {
            throw new Exception('divisa required');
        }

        if ($this->codTrans != null && !empty($this->codTrans)) {
            $this->urlRedirect .= '&codTrans=' . $this->codTrans;
        } else {
            throw new Exception('codTrans required');
        }

        if ($this->url != null && !empty($this->url)) {
            $this->urlRedirect .= '&url=' . $this->url;
        } else {
            throw new Exception('url required');
        }

        if ($this->urlBack != null && !empty($this->urlBack)) {
            $this->urlRedirect .= '&url_back=' . $this->urlBack;
        } else {
            throw new Exception('urlBack required');
        }

        if ($this->languageId != null && !empty($this->languageId)) {
            $this->urlRedirect .= '&languageId=' . $this->languageId;
        }

        if ($this->urlpost != null && !empty($this->urlpost)) {
            $this->urlRedirect .= '&urlpost=' . $this->urlpost;
        }

        if ($this->descrizione != null && !empty($this->descrizione)) {
            $this->urlRedirect .= '&descrizione=' . $this->descrizione;
        }

        if ($this->sessionId != null && !empty($this->sessionId)) {
            $this->urlRedirect .= '&session_id=' . $this->sessionId;
        }
        
        if ($this->mail != null && !empty($this->mail)) {
            $this->urlRedirect .= '&mail=' . $this->mail;
        }
        
        if ($this->Note1 != null && !empty($this->Note1)) {
            $this->urlRedirect .= '&Note1=' . $this->Note1;
        }
        
        if ($this->Note2 != null && !empty($this->Note2)) {
            $this->urlRedirect .= '&Note2=' . $this->Note2;
        }

        $this->urlRedirect .= '&mac=' . $this->macCalcolato();
    }

    /**
     * @return the urlRedirect
     */
    public function getUrlRedirect()
    {
        return $this->urlRedirect;
    }

    /**
     * @param urlRedirect the urlRedirect to set
     */
    public function setUrlRedirect($urlRedirect)
    {
        $this->urlRedirect = $urlRedirect;
    }
}
