{*
* NOTICE OF LICENSE
*
* This file is licenced under the Software License Agreement.
* With the purchase or the installation of the software in your application
* you accept the licence agreement.
*
* You must not modify, adapt or create derivative works of this source code
*
*  @author    PrestaHeroes <info@prestaheroes.com>
*  @copyright 2016 Heroic Business Solutions LLC
*}
</div>
<div class="col-xs-12">
<script type="text/javascript">
$( document ).ready(function() {
    /* activate sidebar */
    $('#sidebar').affix({
      offset: {
        top: $('#sidebar').offset().top
      }
    });

    /* activate scrollspy menu */
    var $body   = $(document.body);
    var navHeight = $('#sidebar').outerHeight(true);

    $body.scrollspy({
        target: '#leftCol',
        offset: navHeight
    });
    var offset = 145;

  $('#sidebar li a').click(function(event) {
      event.preventDefault();
      $($(this).attr('href'))[0].scrollIntoView();
      scrollBy(0, -offset);
  });
});
</script>
<style type="text/css">
    .affix-top,.affix{
 position: static;
}

@media (min-width: 979px) {
  #sidebar.affix-top {
    position: static;
    margin-top:130px;
    width:228px;
  }

  #sidebar.affix {
    position: fixed;
    top:145px;
    width:228px;
  }
}

#sidebar li.active {
  border:0 #eee solid;
  border-right-width:5px;
}

</style>
<!--main-->
    <div class="row">
      <!--left-->
      <div class="col-md-3" id="leftCol">
        <ul class="nav nav-stacked" id="sidebar">
          <li><a href="#sec-intro">{l s='Introduction' mod='geotargetingpro'}</a></li>
          <li><a href="#sec-pricebycountry">{l s='Setting Product Price by Country' mod='geotargetingpro'}</a></li>
          <li><a href="#sec-pricecartrule">{l s='Setting Specific Price by Country using Cart rules' mod='geotargetingpro'}</a></li>
          <li><a href="#sec-configtab">{l s='Configuration Tab' mod='geotargetingpro'}</a></li>
          <li><a href="#sec-geoipsource">{l s='GEOIP Source Tab' mod='geotargetingpro'}</a></li>
          <li><a href="#sec-simulator">{l s='Country Simulator Tab' mod='geotargetingpro'}</a></li>
          <li><a href="#sec-blacklisted">{l s='Black Listed IP(s) Tab' mod='geotargetingpro'}</a></li>
          <li><a href="#sec-resolveip">{l s='Resolve IP Tab' mod='geotargetingpro'}</a></li>
          <li><a href="#sec-stats">{l s='Geo Insights Tab' mod='geotargetingpro'}</a></li>
        </ul>
      </div><!--/left-->

      <!--right-->
      <div class="col-md-9">
        <h2 id="sec-intro">{l s='Introduction' mod='geotargetingpro'}</h2><br>
        <h3>{l s='Using PrestaShop Product Price by Country' mod='geotargetingpro'}</h3>
        <ol><li>{l s='How to set a product price by country?' mod='geotargetingpro'}</li>
        <p>{l s='Use native Prestashop: Admin-->Catalog-->Products-->Edit a product-->Add new specific price ‘by country’' mod='geotargetingpro'}
        <li>{l s='How to set default currency by country?' mod='geotargetingpro'}</li>
        <p>{l s='Use native Prestashop: Admin-->Localization-->Countries-->Edit a country-->Set country default currency' mod='geotargetingpro'}</p></ol>

        <hr>
        <h2 id="sec-pricebycountry">{l s='Setting Product Price by Country' mod='geotargetingpro'}</h2><br>
        <p>{l s='To create price by country for single product you need to use specific prices. Choose your country from drop-down and fill other options to fit your needs.' mod='geotargetingpro'}</p><br>
        <div class="row">
          <div class="col-md-12"><img src="{$this_path|escape:'htmlall':'UTF-8'}views/img/guide-geotargetingpro2.png" class="img-responsive"></div>
        </div><br>
        <p>{l s='In this example we have set different prices for three countries and all using "fixed price", but they also could be set as discount by percentage or amount. ' mod='geotargetingpro'}</p><br>
        <div class="row">
          <div class="col-md-12"><img src="{$this_path|escape:'htmlall':'UTF-8'}views/img/guide-geotargetingpro1.png" class="img-responsive"></div>
        </div>
        <h2 id="sec-pricecartrule">{l s='Setting Specific Price by Country using Cart rules' mod='geotargetingpro'}</h2><br>
        <p>{l s='Use native Prestashop: Admin-->Catalog-->Price Rules-->Catalog Price Rules-->Add new catalog price rule' mod='geotargetingpro'} </p><br>
        <p>{l s='Choose country from drop-down and fill other options to fit your needs.' mod='geotargetingpro'} </p><br>
        <div class="row">
          <div class="col-md-12"><img src="{$this_path|escape:'htmlall':'UTF-8'}views/img/guide-geotargetingpro3.png" class="img-responsive"></div>
        </div>
        <p>{l s='To narrow down influence of cart rule you can add new condition group. This way you can target just products from specific category, manufacturer, supplier or target products with specific attribute or feature.' mod='geotargetingpro'} </p><br>
        <div class="row">
          <div class="col-md-12"><img src="{$this_path|escape:'htmlall':'UTF-8'}views/img/guide-geotargetingpro4.png" class="img-responsive"></div>
        </div>

        <hr>

        <h2 id="sec-configtab">{l s='Configuration Tab' mod='geotargetingpro'}</h2>
        <p>
          {l s='Upon visitor entry, if no country set in visitor cookie PrestaShop will query internal database for IP country.When IP resolved visitor cookie county is set.  PrestaShop will then localize your catalog on this country.When IP does NOT resolve.  PrestaShop will disallow shopping.  Geo Targeting Pro allows you to configure a default country for non-resolved IP’s so visitor can shop.' mod='geotargetingpro'} <br>
          {l s='Geo Targeting Pro module extend PrestaShop Geolocalization by selecting default country for non-resolved IP. You can set your default country here or country from which you get most visitors.' mod='geotargetingpro'}
        </p><br>
        <div class="row">
          <div class="col-md-12"><img src="{$this_path|escape:'htmlall':'UTF-8'}views/img/guide-geotargetingpro5.png" class="img-responsive"></div>
        </div>
        <p>{l s='Address override is there ' mod='geotargetingpro'} </p><br>

        <hr>

        <h2 id="sec-geoipsource">{l s='GEOIP Source Tab' mod='geotargetingpro'}</h2>
        <p>
          {l s='Native PrestaShop use free open source GEOIP2 Lite database from MaxMind. It offers good accuracy in most cases but as database itself is build with less data, some mistakes are possible. And some IP can get unresolved.' mod='geotargetingpro'}<br>
        </p>
        <p>
          {l s='MaxMind\'s GEOIP2 Country paid database offers accuracy of 99.8%. After you acquire GeoIP2 Country database file you can use it in Geo Targeting Pro module. First choose second options on GeoIP Source Tab. Upload database file, make sure it is .mmdb file extension (GeoIP2-Country.mmdb) and not compressed in .zip for example. Do not forget to click Save button. Here you can also get information when GeoIP Country database was uploaded. That is important because MaxMaind constantly improves and updates database.'  mod='geotargetingpro'}<br>
        </p>
        <p>
          {l s='If you have trouble with upload limit, do check with your hosting to increase upload limit to 4 or 8 MB. Alternative method to upload database file is to transfer it directly to folder `/modules/geotargetingpro/lib/geodata` using hosting File Manager or some FTP software.'  mod='geotargetingpro'}<br>
        </p>
        <div class="row">
          <div class="col-md-12"><img src="{$this_path|escape:'htmlall':'UTF-8'}views/img/guide-geotargetingpro6.png" class="img-responsive"></div>
        </div>
        <p>
          {l s='MaxMind\'s GeoIP2 Precision Services offers most accurate service and direct access to weekly updated databases. Notice for Country database it can not be more precise then down-loadable GEOIP2, because Precision Service gives more improvement in city and post code data that are not used in Geo Targeting Pro module.'  mod='geotargetingpro'}<br>
        </p>
        <div class="row">
          <div class="col-md-12"><img src="{$this_path|escape:'htmlall':'UTF-8'}views/img/guide-geotargetingpro7.png" class="img-responsive"></div>
        </div>
        <hr>

        <h2 id="sec-simulator">{l s='Country Simulator Tab' mod='geotargetingpro'}</h2>
        <p>
          {l s='From your browser you can simulate a visitors experience by selected country or country by IP. PrestaShop remembers visitors cookie so make sure to clear browser cookie for each NEW country test. Make sure simulator is enabled. If in Simulator Type, Simulate by IP is selected you need to fill specific IP that you want to test. And last necessary field is actual IP that is tested from. You can easily add your own IP here.'  mod='geotargetingpro'}<br>
        </p>
        <div class="row">
          <div class="col-md-12"><img src="{$this_path|escape:'htmlall':'UTF-8'}views/img/guide-geotargetingpro8.png" class="img-responsive"></div>
        </div>
        <p>
          {l s='Other option in Simulator type is to simulate country by choosing it from drop-down. PrestaShop remembers visitors cookie so make sure to clear browser cookie for each NEW country test you do in Front Office. '  mod='geotargetingpro'}<br>
        </p>
        <div class="row">
          <div class="col-md-12"><img src="{$this_path|escape:'htmlall':'UTF-8'}views/img/guide-geotargetingpro9.png" class="img-responsive"></div>
        </div>
        <hr>


        <h2 id="sec-blacklisted">{l s='Black Listed IP(s) Tab' mod='geotargetingpro'}</h2>
        <p>{l s='Black listed IP(s) use opposite behavior then one defined in native PrestaShop Admin->Prefrences-->Geo Location-->Geolocation (White listed IP addresses). It blocks access to list of IP that could be used by spam bots.' mod='geotargetingpro'}<p>

        <hr>

        <h2 id="sec-resolveip">{l s='Resolve IP Tab' mod='geotargetingpro'}</h2>
        <p>{l s='Display IP information from free GEOIP Lite City database and if it is selected from paid GEOIP2 Country database. In some cases you could see difference between two and then you can see better precision of GEOIP2 Country database.' mod='geotargetingpro'}<p>
        <div class="row">
          <div class="col-md-12"><img src="{$this_path|escape:'htmlall':'UTF-8'}views/img/guide-geotargetingpro10.png" class="img-responsive"></div>
        </div>
        <hr>

        <h2 id="sec-stats">{l s='Geo Insights Tab' mod='geotargetingpro'}</h2>
        <p>{l s='On this that you can enable simple statistics of resolved IP. Also you can clear statistics by reseting numbers to zero.' mod='geotargetingpro'}<p>

        <div class="row">
          <div class="col-md-12"><img src="{$this_path|escape:'htmlall':'UTF-8'}views/img/guide-geotargetingpro11.png" class="img-responsive"></div>
        </div>


        </div><!--/right-->
    </div><!--/row-->

</div>