/**
* NOTICE OF LICENSE
*
* This file is licenced under the Software License Agreement.
* With the purchase or the installation of the software in your application
* you accept the licence agreement.
*
* You must not modify, adapt or create derivative works of this source code
*
*  @author    PrestaHeroes <info@prestaheroes.com>
*  @copyright 2016 Heroic Business Solutions LLC
*  @license   commercial
*/

function checkSimulatorType()
{
   var type = parseInt($('.simulator-type input:checked').val(), 10);

   if (type)
   {
        $('.ip-simulator').parents('.form-group').show();
        $('.country-simulator').parents('.form-group').hide();
   }
   else
   {
        $('.country-simulator').parents('.form-group').show();
        $('.ip-simulator').parents('.form-group').hide();
   }
}
function checkPrimaryType()
{
   var type = parseInt($("input[name='GTP_PRIMARY_LOOKUP']:checked").val(), 10);

   switch(type) {
        case 1:
            $('.licenseinfo').parents('.form-group').hide();
            $('#GTP_MM_USER_ID').parents('.form-group').hide();
            $('#GTP_MM_LICENSE_KEY').parents('.form-group').hide();

            $('.countrydbinfo').parents('.form-group').show();
            $('#GTP_GEOIP2_COUNTRY_FILE').parents('.form-group').show();
            break;
        case 2:
            $('.licenseinfo').parents('.form-group').show();
            $('#GTP_MM_USER_ID').parents('.form-group').show();
            $('#GTP_MM_LICENSE_KEY').parents('.form-group').show();

            $('.countrydbinfo').parents('.form-group').hide();
            $('#GTP_GEOIP2_COUNTRY_FILE').parents('.form-group').hide();
            break;
        default:
            $('.licenseinfo').parents('.form-group').hide();
            $('#GTP_MM_USER_ID').parents('.form-group').hide();
            $('#GTP_MM_LICENSE_KEY').parents('.form-group').hide();

            $('.countrydbinfo').parents('.form-group').hide();
            $('#GTP_GEOIP2_COUNTRY_FILE').parents('.form-group').hide();
    }

}
$(document).ready(function() {
    checkSimulatorType();
    checkPrimaryType();
    $(document).on('change', '.simulator-type input', function() {
        checkSimulatorType();
    });
    $(document).on('change', "input[name='GTP_PRIMARY_LOOKUP']", function() {
        checkPrimaryType();
    });
    $(document).on('click', '#module_form a[data-toggle="tab"]', function(e){
        $('input[name="GTP_ACTIVE_TAB"]').val($(this).attr('href'));
    });

    $(document).on('click', '#clear_stats', function(e){
        e.preventDefault();
        $("#GTP_GEO_STATS_CLEAR").val("true");
        $(this).closest("form").submit();
    });
    $(document).on('click', '#refresh_stats', function(e){
        e.preventDefault();
        $.ajax({
            type : 'POST',
            dataType : 'json',
            url : ajaxlink,
            data : {
                //required parameters
                ajax : true,
                action : 'GetGeoStats',
                token : admin_token
            },
        }).done(function(data){
            $('.resolve-icon').fadeOut('normal', function(){
                $('.resolve-icon').fadeIn();
            });
            $('#resolved-icon-percentage').text();
        })
    });

});

function addRemoteAddr()
{
    var length = $('input[name=GTP_ORG_IP_ADDR]').attr('value').length;
    if (length > 0)
        $('input[name=GTP_ORG_IP_ADDR]').attr(
        	'value',
        	$('input[name=GTP_ORG_IP_ADDR]').attr('value') + ',' + remote_address
        );
    else
        $('input[name=GTP_ORG_IP_ADDR]').attr('value', remote_address);
}
$( window ).load(function() {
        var activeTab = $('input[name="GTP_ACTIVE_TAB"]').val();
        $('.nav-tabs a[href="' + activeTab + '"]').tab('show');
});