<?php
/**
* NOTICE OF LICENSE
*
* This file is licenced under the Software License Agreement.
* With the purchase or the installation of the software in your application
* you accept the licence agreement.
*
* You must not modify, adapt or create derivative works of this source code
*
*  @author    PrestaHeroes <info@prestaheroes.com>
*  @copyright 2016 Heroic Business Solutions LLC
*  @license   commercial
*/

class FrontController extends FrontControllerCore
{
    private $blacklist;
    protected function geolocationManagement($default_country)
    {
        if (!Module::isEnabled('geotargetingpro') || !Configuration::get('PS_GEOLOCATION_ENABLED')) {
            return parent::geolocationManagement($default_country);
        }
        $this->blacklist = explode(',', Configuration::get('GTP_BLACK_LIST'));
        if (!isset($this->context->cookie->iso_code_country) || (isset($this->context->cookie->iso_code_country) &&
        !in_array(
            Tools::strtoupper($this->context->cookie->iso_code_country),
            explode(';', Configuration::get('PS_ALLOWED_COUNTRIES'))
        ))) {
            if (Configuration::get('GTP_IPSIMULATOR') && (in_array(
                Tools::getRemoteAddr(),
                explode(',', Configuration::get('GTP_ORG_IP_ADDR'))
            ))) {
                if (Configuration::get('GTP_SYMTYPE')) {
                    $gip =  Configuration::get('GTP_IP2_SIMULATE');
                } else {
                    $gip = '207.160.169.253';
                }
            }
            if (!isset($gip)) {
                if (in_array($_SERVER['SERVER_NAME'], array('localhost', '127.0.0.1'))) {
                    $gip = '207.160.169.253';
                } else {
                    $gip = Tools::getRemoteAddr();
                }
            }
            include_once(_PS_MODULE_DIR_.'geotargetingpro/lib/classes/vendor/autoload.php');
            $isValidIp = filter_var($gip, FILTER_VALIDATE_IP);
            if ($isValidIp) {
                $record_iso_country_code = '';
                $primary = (int) Configuration::get('GTP_PRIMARY_LOOKUP');
                if ($primary == 0) {
                    try {
                        include_once(_PS_GEOIP_DIR_.'geoipcity.inc');
                        $city_file = 'GeoLiteCity.dat';
                        $gi = geoip_open(realpath(_PS_GEOIP_DIR_.$city_file), GEOIP_STANDARD);
                        $record = geoip_record_by_addr($gi, $gip);
                        $record_iso_country_code = $record->country_code;
                        if ((bool)Configuration::get('GTP_GEO_STATS')) {
                            $total = (int)Configuration::get('GTP_STAT_TOTAL');
                            $resolved = (int)Configuration::get('GTP_STAT_RESOLVED');
                            Configuration::updateValue('GTP_STAT_TOTAL', $total+1);
                            Configuration::updateValue('GTP_STAT_RESOLVED', $resolved+1);
                        }
                    } catch (\GeoIp2\Exception\AddressNotFoundException $e) {
                        $record = null;
                        if ((bool)Configuration::get('GTP_GEO_STATS')) {
                            $total = (int)Configuration::get('GTP_STAT_TOTAL');
                            $nonResolved = (int)Configuration::get('GTP_STAT_NON_RESOLVED');
                            Configuration::updateValue('GTP_STAT_TOTAL', $total+1);
                            Configuration::updateValue('GTP_STAT_NON_RESOLVED', $nonResolved+1);
                        }
                    }
                }

                $country_db = _PS_MODULE_DIR_.'geotargetingpro/lib/geodata/GeoIP2-Country.mmdb';
                if ($primary == 1 && file_exists($country_db)) {
                    try {
                        $creader = new GeoIp2\Database\Reader($country_db);
                        $record = $creader->country($gip);
                        $record_iso_country_code = $record->country->isoCode;
                        if ((bool)Configuration::get('GTP_GEO_STATS')) {
                            $total = (int)Configuration::get('GTP_STAT_TOTAL');
                            $resolved = (int)Configuration::get('GTP_STAT_RESOLVED');
                            Configuration::updateValue('GTP_STAT_TOTAL', $total+1);
                            Configuration::updateValue('GTP_STAT_RESOLVED', $resolved+1);
                        }
                    } catch (\GeoIp2\Exception\AddressNotFoundException $e) {
                        $record = null;
                        if ((bool)Configuration::get('GTP_GEO_STATS')) {
                            $total = (int)Configuration::get('GTP_STAT_TOTAL');
                            $nonResolved = (int)Configuration::get('GTP_STAT_NON_RESOLVED');
                            Configuration::updateValue('GTP_STAT_TOTAL', $total+1);
                            Configuration::updateValue('GTP_STAT_NON_RESOLVED', $nonResolved+1);
                        }
                    }
                } elseif ($primary == 2) {
                    try {
                        $userId = Configuration::get('GTP_MM_USER_ID');
                        $licenseKey = Configuration::get('GTP_MM_LICENSE_KEY');
                        $client = new GeoIp2\WebService\Client($userId, $licenseKey);
                        $record = $client->country($gip);
                        $record_iso_country_code = $record->country->isoCode;
                        if ((bool)Configuration::get('GTP_GEO_STATS')) {
                            $total = (int)Configuration::get('GTP_STAT_TOTAL');
                            $resolved = (int)Configuration::get('GTP_STAT_RESOLVED');
                            Configuration::updateValue('GTP_STAT_TOTAL', $total+1);
                            Configuration::updateValue('GTP_STAT_RESOLVED', $resolved+1);
                        }
                    } catch (\GeoIp2\Exception\AuthenticationException $e) {
                        $record = null;
                        if ((bool)Configuration::get('GTP_GEO_STATS')) {
                            $total = (int)Configuration::get('GTP_STAT_TOTAL');
                            $nonResolved = (int)Configuration::get('GTP_STAT_NON_RESOLVED');
                            Configuration::updateValue('GTP_STAT_TOTAL', $total+1);
                            Configuration::updateValue('GTP_STAT_NON_RESOLVED', $nonResolved+1);
                        }
                    }
                }
            } else {
                $record =  null;
                if ((bool)Configuration::get('GTP_GEO_STATS')) {
                    $total = (int)Configuration::get('GTP_STAT_TOTAL');
                    $nonResolved = (int)Configuration::get('GTP_STAT_NON_RESOLVED');
                    Configuration::updateValue('GTP_STAT_TOTAL', $total+1);
                    Configuration::updateValue('GTP_STAT_NON_RESOLVED', $nonResolved+1);
                }
            }

            if (is_object($record)) {
                if ((Configuration::get('GTP_IPSIMULATOR') && (in_array(
                    Tools::getRemoteAddr(),
                    explode(',', Configuration::get('GTP_ORG_IP_ADDR'))
                )) && !Configuration::get('GTP_SYMTYPE'))) {
                        $record_iso_country_code = Tools::strtoupper(Configuration::get('GTP_COUNTRY2_SIMULATE'));
                }
                if (!in_array(
                    Tools::strtoupper($record_iso_country_code),
                    explode(';', Configuration::get('PS_ALLOWED_COUNTRIES'))
                )  || in_array($gip, $this->blacklist)) {
                    if (Configuration::get('GTP_DEFAULT_COUNTRY') && !in_array($gip, $this->blacklist)) {
                        $has_been_set = !isset($this->context->cookie->iso_code_country);
                        $this->context->cookie->iso_code_country = Tools::strtoupper(
                            Configuration::get('GTP_DEFAULT_COUNTRY')
                        );
                    } elseif (Configuration::get('PS_GEOLOCATION_BEHAVIOR') == _PS_GEOLOCATION_NO_CATALOG_) {
                        $this->restrictedCountry = true;
                    } elseif (in_array($gip, $this->blacklist)) {
                        $this->restrictedCountry = true;
                    } elseif (Configuration::get('PS_GEOLOCATION_BEHAVIOR') == _PS_GEOLOCATION_NO_ORDER_) {
                        $this->context->smarty->assign(array(
                            'restricted_country_mode' => true,
                            'geolocation_country' => $record->country_name
                        ));
                    }
                } else {
                    $has_been_set = !isset($this->context->cookie->iso_code_country);
                    $this->context->cookie->iso_code_country = Tools::strtoupper($record_iso_country_code);
                }
            } else {
                if (Configuration::get('GTP_DEFAULT_COUNTRY') && !in_array($gip, $this->blacklist)) {
                    $has_been_set = !isset($this->context->cookie->iso_code_country);
                    $this->context->cookie->iso_code_country = Tools::strtoupper(
                        Configuration::get('GTP_DEFAULT_COUNTRY')
                    );
                } elseif (in_array($gip, $this->blacklist)) {
                    $this->restrictedCountry = true;
                }
            }
        }
        if (isset($this->context->cookie->iso_code_country) &&
            $this->context->cookie->iso_code_country &&
            !Validate::isLanguageIsoCode($this->context->cookie->iso_code_country)
        ) {
            $this->context->cookie->iso_code_country = Country::getIsoById(Configuration::get('PS_COUNTRY_DEFAULT'));
        }
        if (isset($this->context->cookie->iso_code_country) &&
            ($id_country = Country::getByIso(Tools::strtoupper($this->context->cookie->iso_code_country)))
        ) {
            if ($default_country->iso_code != $this->context->cookie->iso_code_country) {
                $default_country = new Country($id_country);
            }
            if (isset($has_been_set) && $has_been_set) {
                $this->context->cookie->id_currency = (int)(Currency::getCurrencyInstance(
                    $default_country->id_currency?
                    (int)$default_country->id_currency:
                    Configuration::get('PS_CURRENCY_DEFAULT')
                )->id);
            }
            return $default_country;
        } elseif (Configuration::get('PS_GEOLOCATION_NA_BEHAVIOR') == _PS_GEOLOCATION_NO_CATALOG_ &&
            !FrontController::isInWhitelistForGeolocation()
        ) {
            $this->restrictedCountry = true;
        } elseif (Configuration::get('PS_GEOLOCATION_NA_BEHAVIOR') == _PS_GEOLOCATION_NO_ORDER_ &&
            !FrontController::isInWhitelistForGeolocation()
        ) {
            $id_country = Country::getByIso($record->country_code);
            $recordCountry = new Country((int)$id_country, (int)$this->context->language->id);
            $this->context->smarty->assign(array(
                'restricted_country_mode' => true,
                'geolocation_country' => isset($recordCountry->name) ? $recordCountry->name : 'Undefined'
            ));
        }
        return $default_country;
    }
}
